META
key;value
description;District PB in Warszawa, Rembertów
country;Poland
unit;Warszawa
district;Rembertów
subunit;Rembertów
instance;2024
num_projects;36
num_votes;1374
budget;1014271
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
1743;67500;632;Nasadzenia krzewów miodo i pyłkodajnych - Chruściela;urban greenery;children,seniors;1;52.2686945260379;21.179580688476562
1062;65000;622;Rembertowskie kino pod gwiazdami;culture,public space;children,seniors;1;;
1732;10500;519;Chronimy ptaki Rembertowa - utrzymanie (oczyszczenie ze starych gniazd) skrzynek lęgowych;environmental protection;;1;52.26260892286206;21.16020011901856
546;167500;507;Nowości wydawnicze i spotkania w Twojej bibliotece;education,culture;children,seniors;1;52.252512584448816;21.154955202579757
1059;12800;498;Robotyka - bezpłatne warsztaty dla dzieci;education,culture;children;1;;
551;33000;463;Rembertowski Uniwersytet Dziecięcy w bibliotece;education,culture;children;1;52.2585768;21.1629533
1019;95000;456;Cykl koncertów, przedstawień teatralnych, warsztatów i rodzinnych pikników w Domu Kultury „Rembertów”;education,culture;children,seniors;1;52.2542413;21.1632527
549;160020;439;Nasadzenia krzewów miodo i pyłkodajnych - Ziemskiego;urban greenery;children,seniors;1;52.25846535593449;21.17799282073975
1298;89650;432;Strefa ocr ninja, sport na powietrzu;education,culture,environmental protection,public space,sport,urban greenery;children,seniors;1;52.26067185517152;21.153831481933594
1742;36000;417;Nasadzenia krzewów miodo i pyłkodajnych - Szatkowników;urban greenery;children,seniors;1;52.25867550344886;21.178121566772464
1459;200000;412;Zielone wiaty przystankowe przy SP217 (przystanki Zawodowa);education,public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.26300835;21.156425378908
972;197415;405;Remont podwórka przy Domu Kultury Rembertów;culture,public space;children,seniors;0;52.254226073905;21.163321137428
1169;30150;373;Ławki dla karmiących matek;public space;;1;52.252640578208094;21.151592731475834
1178;200000;364;Radarowy wyświetlacz prędkości na ul. Paderewskiego;public transit and roads,public space;children,seniors;0;52.26476915890154;21.156063079833984
904;71240;362;Jadłodzielnia z wiatą;public space;children,seniors;0;52.2582321;21.17108605599637
1061;5700;358;Aktywne lato w Domu Kultury Wygoda - bezpłatne zajęcia fitness;sport;seniors;1;52.248660599999994;21.127582571384842
954;145230;355;Jadłodzielnie na osiedlach Kawęczyn-Wygoda i Nowy Rembertów;welfare;children,seniors;0;52.250665407255475;21.14941120147705
1005;53700;354;Szachy na Wygodzie;education,culture;children;0;52.246773000000005;21.136213661466165
1060;16200;351;W 80 dań dookoła świata - cykl bezpłatnych warsztatów kulinarnych;culture,environmental protection;children,seniors;1;52.248660599999994;21.127582571384842
439;18500;346;Rembertowski Klub Filmowy;education,culture;children,seniors;1;52.2585768;21.1629533
1733;4500;338;Dofinansowanie pracowni malarskiej Rembertowskiej Akademii Seniora;education,culture,public space;children,seniors;1;52.25888689999999;21.16187958174757
95;18000;328;Warsztaty psychologiczne i zielarskie na Wygodzie;education,welfare;;0;52.248660599999994;21.127582571384842
1457;34150;323;Edukacja ekologiczna młodych rembertowian – szkolny ogród warzywny w SP 217;education,environmental protection,public space,urban greenery;children,seniors;0;52.26300835;21.156425378908
1007;46100;318;Kółko teatralne na Wygodzie;education,culture;children;0;52.24685315837232;21.136107444763187
1013;25000;317;Warsztaty bębniarskie w szkole na Wygodzie;education,culture;children,seniors;0;52.246773000000005;21.136213661466165
1173;85000;309;Grudniowa iluminacja ul. Frontowej;public space;children,seniors;0;52.26180133015504;21.1732292175293
195;30220;302;Posadzenie pnączy wzdłuż ul. Kramarskiej;urban greenery;children,seniors;0;52.2739046;21.1505552
973;200000;296;Radarowe wyświetlacze prędkości na ul. Chełmżyńskiej;public transit and roads,public space;children,seniors;0;52.24994268252489;21.13102197647095
1399;97000;274;Mural na SP 217;education,public transit and roads,public space,sport,urban greenery;children,seniors;0;52.26300835;21.156425378908
1165;108000;257;Mural Marszałku wróć;culture;children,seniors;0;52.25888689999999;21.16187958174757
609;25000;256;Zabawy taneczne przy muzyce na żywo w Domu Kultury „Rembertów”;education,culture;children,seniors;0;52.254111548562;21.16346597671509
1009;52800;256;Warsztaty kolędowania na Wygodzie;education,culture;children;0;52.246773000000005;21.136213661466165
1038;24500;245;Spotkania podróżnicze i kulinarne w Domu Kultury „Rembertów”;education,culture;children,seniors;0;52.2542413;21.1632527
591;4900;239;Sąsiedzkie warsztaty w Domu Kultury Rembertów;culture;children,seniors;0;52.2542413;21.1632527
1160;185950;190;Fotoplastykon;education,culture;children,seniors;0;52.25918578425979;21.162576522369356
1008;23000;155;Mölkky w Rembertowie;education,sport;children,seniors;0;52.26245798843233;21.155076026916504
VOTES
voter_id;vote;age;sex
128;904,954;36;M
299;904,1060,439,954,1062,95;56;F
581;1008,551,954,904,1061,972,95,1059,549,1457,1743,1732,1459,195,1742;27;F
643;1457,1743,1742,549,1732,195;41;F
770;1165,1399,1459,1298,1733,1743,1732,1008,1742,972,904,954,195,439,546;46;F
891;1178,1298,1165,1457,1459,1399,195,1160,1173;17;M
917;1178,1298,609,1062,195;48;M
1091;609,972,1019,1038,591;33;F
1161;195,973,1038,1013,1742,954,1298,1169,1165,1399,1062,549,1059,1160,1173;38;M
1246;1060,546,95,1743,1061,1457,1165,1169,549,1459,904,954,1733,1732,1399;54;F
1252;1005,1007,1009,1013;42;M
1374;1743,439,1062,1742,1457,1459,1399,1059,195;44;F
1594;1019,1062,972;21;M
1664;1008;53;M
1697;549,1165,1732,1173;52;F
1863;1005,1743,195,954,1742,549,1457,1732,1459,1173;22;M
2100;609,1169,1005,1060,1008,1019,1038,1062;37;M
2375;1059,904,1399,1459,549,1298,1732,1019,195,1062,1178,1743,546,439,551;39;F
2380;1019,1733,1165,1178,1457,1743,1459,546,1399,195,1160,1173;37;F
2446;1061,546,95,1009,1013,609,1733,972,1060,1059,551,1019,1038,1173,1062;44;F
2556;1009,1007,1005,1013;6;F
2620;1178,549,1169,1457,1743,1732,1459,972,1059,551,1019,195,1160,1742,954;31;M
2636;972,546,1060,1019;34;F
2723;549,1457,546,551,1742,1459,1732,1743,1178,195,973,954;22;M
2965;1743,1459,546,904,439,551,195,1173,1062,1178,1298,1732,972,1399,1059;38;M
3554;1178,1005,1169,1007,609,904,1059,1062,954,973;24;F
3568;1038,1742,195,1173,1062,954,1013,973,439,1009,1399,95,1061,1457,1007;23;M
3626;549,1743,1459,195,1742,1005,1169,1007,1457,1061,1732,95,1009,973,1013;44;F
3694;1019,551,95,546,972,1298,1005,1007,1061,1060,1009,1062,1059,1013;35;F
3713;1061,972,1019,973,1038;50;M
3740;1019,1742,1732,1005,1007,1061,546,95,1060,1009,1059,551,973,1013,954;43;F
3832;1298,1005,1007,1061,972,546,95,1060,1009,1059,439,551,1019,1013,1062;44;M
3931;1732,1459,1399,1059,551,195;46;M
4032;95,1160,1013,1742,954,1005,1007,1061,1059,973,1062;37;F
4056;972,609,1062,1733,549,1298,1061,1743,1732,1459,546,1399,1059,1173,1742;21;M
4144;546,1178,1298,1457,1459,1399,904,1060,1059,439,551,973,1160,1062,954;40;F
4181;1008,551,954,1005,1298,1007,1061,1732,904,1060,1009,1059,973,1013,1062;40;M
4199;1005,1007,1009,1059,1013;43;F
4216;1013,954,904,1298,1005,1007,1061,1732,95,1009,1059,1019,973,591,1062;40;F
4237;1457,546,972,1732,1005,1178,1013,954,1059,973;47;M
4290;609,1019,1062,1061,1732,954,1060,973;54;F
4454;1742,1062,1059,1009,95,1743,1061,1007,1005,549,1060,1013;35;M
4576;1019,551,1059,904,1732,1178,1013,1062,1005,1007,1061,95,1009,439,973;54;F
4718;1013,95,1061,1169,549,1062,973,1007,954;51;M
4790;954,1061,1399,1060,1059,551,1019,1160,549,1298,1165,1733,1743,904,1173;50;M
4823;1178,1733,1743,95,904,1060,439,1013,1169,1298,1062,973,954,1061,546;23;F
4826;972,954,195,904,1733,1005,549,1169,1457,1743,1732,1459,546,1742;30;F
5041;1007,1061,1732,95,904,1060,1019,973,1038;50;F
5110;1732,195,609,1009,1005,1007,1061,95,904,1060,973,1038,1013,1062,954;51;F
5287;1061,95,973,954;45;F
5332;1743,1169,1178,1742,1173,1062,1005,1007,1061,95,1009,1059,551,973,1013;41;F
5431;1178,1399,1062,1459,195;42;M
5457;1178,1165,1459,1399,1173,1062;48;F
5552;1298,1169,1061,904,1060,973,1013,1062;16;M
5571;954,439,1178,549,1298,1459,904;42;M
5620;1060,1178,549,1169,1733,1457,1743,1732,1459,1059,551,195,973,1173,1742;64;F
5827;1059,551,1742,549,1005,1169,1165,1743,546,904,1019,1173,1062,954,1298;37;F
5882;973,195,904,1743,1160,1298,1165,1732,1169,1005,1178,549,1062,1399,1459;18;F
5993;549,1399,1165,1743,195,1742,1178,1298,972,1459,973;36;M
6126;1165,1178,1008,1173,195,1298,549,1457,1743,1732,1459,1399,1019,1160,1742;37;F
6171;1005,1169,1007,1061,1732,546,95,1009,1059,973,1013,1062;39;F
6185;973;45;M
6349;1169,1061,439,1019;31;F
6369;195;47;F
6565;95;62;M
6654;1019,439,1059,1009,546,1732,1743,1005,1007,1061,95,1060,973,1013,1062;47;F
7272;1742,1457,1733,1298,549,1007,1009,973,1013,954,1005,1169,1061,1732,95;35;F
7377;1005,1062,609,1061,95,904,973,954;48;F
7484;973;22;F
7547;973,1173,954,1005,1007,1061,95,1009,1013,1062;23;F
7555;1007,1733,1743,195,1742,1165,1732,1399,1173,1062;33;F
7598;1178,1743,1732,1459,1059,551,195;46;M
7894;95,972,1007,1061,973;44;F
7954;1061,1005,1009,954,1007,95,1013;36;M
7965;1178,1061,973;67;F
8005;546,1005,1298,1178,1169,1733,549,1743,1732,95,904,1160,1742,954;39;M
8067;1298,1169,1061,546,95,1060,1059,973;40;M
8150;591,972,1743,1298,195,549,609,1061,1059,1038,1742,1062,1019,551,546;32;F
8343;1733,1062,1007,1005,1457,1459,1060,95,195,549,1743,1742,1732,1061,546;38;F
8383;549,1019,1062,591,439,1060,609,1178,1457,1743,546,551;31;F
8580;609,1459,1060,439,1019,1173,591,1061,1038,1178,1298,1457,546,1160,1062;43;F
8621;1459,95,1173,591,1062,439,1059,546,1061,1457,609,972,551,1019,195;36;F
8698;1173,973,1019,439,904,1060,1457,1733,1298,1005,1007,1009,1059,1013,1062;38;F
8925;1732,1399,1169,1007,1743;66;M
9391;973;42;M
9506;609,904,551,1005,1169,1007,1061,546,95,1060,1009,1059,973,1013,1062;43;F
9523;95,1009,1005,549,1169,1007,195,1013,1298,1061,1060,1059,973,1742,1062;12;M
9538;904,972,1732,1457,609,1169,1005,1178,549,1743,95,1009,439,1013,1062;52;F
9776;1160,1173,1013,549,1743,1060,1008,1059,439,1019,1038,591,1742,1732,546;39;F
9804;549,1743,1005,973,1298,1007,1733,1457,972,546,95,1059,439,551,1061;46;M
10054;1459,1732,1733,549;40;F
10473;549,1733,1169,972,1059,1742,954,591,95;42;F
10665;1732,1733,1169,1743,546,95,1059;36;M
10721;1005,1007,1061,1060,1059,1062,1298,1733,973;40;F
10910;1005,1007,1009,1013;38;F
11356;1743,1178,1732,95,1060,1009,551,439,195,1160,1038,1173,1062,609,1019;38;F
11402;1059,1733,972;30;F
11624;1059,551,1013,1742,1060,1169,549,1298,609,1457,1743,1019,1038,1062,954;43;M
11682;954,1457,1733,549,1743,1732,1459,972,95,904,195,1742;38;F
11726;1038,1173,1013,1742,1457,1061,1733,609,1169,549,1743,1732,546,95;44;F
11870;609,591,551,1061,1459,1019,1178,973,1733,1007,1169,1457,972,1038,1013;52;M
11978;1743,1732,1060,195,1173,1062;33;M
12151;1062,591,1173,551,439,1008,1009,972,1457,1169,1019,1298,1743,1459,1178;48;F
12757;1459,195;27;M
12938;1298,954,1062,1019,551,439,1059,1732,1061,609,1007,1005,95,973,1013;30;F
12956;1019,1038,1062,551,1459,1732,1733,1178,1005,1007,1061,95,1009,973,1013;52;F
13255;973,972,1298,1169,1743,1732,546;37;M
14075;954,1013,439,1059,1009,1060,95,972,1061,1005,1007,1062;15;F
14255;1059,1062,1169,1298,609,546,1008,904,591,954,1743,1732,972,551,1019;46;F
14264;1059,439,1742,1169,546,551,954,973;35;F
14382;1013,973,95;53;F
14479;546,1061,549,1298,1169,609,1743,1732,972,904,1059,551,1038,591,954;41;F
14601;546,1457,1459,1178;44;M
14751;1059,1008,1298,1169,1061,551,973,1038,591;29;F
15013;904,1059,973,954,1178,549,1298,1169,1743,1732,1459,546,551,195,1742;39;F
15361;95;65;F
15450;1007,1061,95,1059,1005,1009,973,1013;40;M
15483;1062,551,439,1059,1060,95,972,1743,549,546,1019;33;F
15543;954,904;42;M
15755;1742,1062,551,1457,1178,1298,1165,609,1743,1732,1459,546,1399;43;F
15856;1008;45;M
15977;1165,1457,1459,546,1399,904,1060,1008;50;F
15993;1165,1059,1062,1173;28;F
16000;1457,972,1459,1165,195,904,1173,1742,1062,1178,549,1743,1732,546,1019;50;F
16027;1298,1165,609,1733,1061,1743,1459,1399,1060,439,1019,195,1038,1173,1062;18;F
16067;973,1178,954,1742,1732,549,1169,1165,1743,1459,1399,904,1160,1173,1062;26;F
16079;1173,1742,1733,972,546,95,1008,1019,1038,591,1743,1061,1060,439,1062;49;F
16186;1061,1160,1038,1019,904,1399,546,1743,1733,609,1165,1060,439,1173,1062;48;F
16196;1019,1298,1169,609,1173,1062;39;M
16214;551,1178,549,439,1007,904,973,1013,1742,954,591,1005,1733,1743,546;32;M
16245;546,1059,551,1019,195,1062,1178,1298,1173;36;F
16248;1019,195,973,1160,1038,1173,591,1062,1742,954,1169,1733,1743,1732,904;34;F
16255;1399,1169,1165,904,1160,1173;34;M
16286;1298,1169,609,1743,972,546,95,1060,439,551,1019,1038,1173,591,1062;32;F
16301;1178,549,1298,1165,1457,1743,1732,1459,546,1399,1173,1062,1742;9;M
16342;609,972,1019,591,1038;31;F
16372;1298,1007,1459,546,1008,1742,973,1399,1169,1005,1165,439,1160,1173,1062;34;M
16382;1178,1298,1169,1457;34;M
16402;1732,1038,1173,1178,1457,1743,1459,972,546,1399,1060,439,551,1019,1062;35;F
16420;1062,1059,546,1457,609,1298,1459,972,1399,551,1019;39;F
16424;1038,1298,1169,609,972,546,95,1059,439,551,1019,1173,591,1062,1742;3;F
16524;549,1732,972,195,1742,954,1169,1165,904,1173,1160;49;M
16629;1173,973,195,1399,1459,1178;16;M
16641;546,1008,1019,1062,1178,1457,1059,1160,1298,1459;36;M
16729;549,1743,546,1009,1059,551,1742,954,1178,1005,1169,1732,973;45;M
16876;1169,609,972,1059,551,1019,195,1038,591,1062,1733,546,904,439,954;39;F
16923;954,1298,1733,1457,1732,1459,904,1008,195,549,1743,546,1019,1173,1742;32;F
16926;1743,904,1169,546,195;40;F
17107;954,1062,1060,1733,1165,1169,1298,1178,1457,1732,1459,1399,904,1160,1173;48;F
17144;1061,95,1013,1009,1007,1005;36;F
17453;549,1743,1732,972,904,1060,195,1038;24;F
17546;1169,1165,1743,904,1160;55;F
17625;546,1732,904,1060,195,973,1173,591,1742,1178,1165,1743,972,1160,954;26;M
17720;609,1733,1062,1178,1165,1743,1459,972,546,1399,904,551,1160,591,954;33;F
17733;1062,1173,1019,439,1008,904,546,1732,1165,1298,1169,1743,1059,551,1160;39;F
17820;195,1169,1061,95,973;28;F
17852;1733,1298,95,1742,1457,1732,1019,1178,1743,972,1038,591;47;F
17893;439;50;M
17897;1733,1169,1178,1005,1007,1061,95,1009,1059,551,973,1173,1013,1062;9;F
17920;1178,1298,1733,1743,1459,972,904;34;F
18023;1169,1165,1743,904;63;M
18130;1457,549,1743,1732,1459,972,546,95,904,439,195,591,1062,1742,954;32;M
18137;973,1060,1457,1733,1169,549,1178,1743,1732,1459,546,1059,195,1062,1742;31;M
18199;1178,1169,1457,1743,1298;33;M
18233;1173,1169,1732;35;F
18283;1169,972,546,954,1742,549,1457,1743,1732,1008,1062,1173,1298,1459,195;17;M
18608;1298,1005,1169,972,1060,1399,1013,1173,1038,1062,1742,954;21;M
18711;1178,1298,1165,95,1008,1059,439;29;M
18767;1732,1459,195;22;F
18896;95,1062,591,1013,1019;37;F
18939;1459,904,973,1742,954,1178,549,1298,1169,1733,1743,1732,972,551,195;39;F
18991;1178,1743,972,551,1298,1733,1732,546,195;36;M
19018;549,1457,1743,1459,972,904,1060,1059,551,1742,954;31;F
19038;1062,954,1733,195,1160,1742,1173,439,1059,1459,1732,1743,1165,1169,549;27;M
19231;1059,551,1019,195,1459,1298;32;M
19261;1732,972,95,439,195,1160,591,1178,1298,1459,546,551,1059,1169,1743;35;M
19527;549,1165,1743,1459;25;M
19681;95;78;F
20258;1173,1062,1742,1169,1732,1059,1298,549,1178,1457,1743,546,972,1019,551;37;F
20291;549,1457,1743,1459,546,95,1060,439,551,1019,1160,1038,591,1062,1742;40;F
20382;1165,1743;26;M
20477;1733,1457,1061,1459,546,95,1059,551,195,1062,1742,1178,1298,1743,1732;44;M
20540;1743,439,195,1160,1038,1742,1061,1459,972,546,1059,551,1019,591,1062;31;F
20695;1178,549,1005,1169,1733,546,439,591,1457,1732,904,1062,1061,1059,973;43;M
20843;1169,1165,904,1160,1173;33;M
20988;609,546,1399,1059,551,1019,1062;37;F
21137;1005;52;M
21140;1742,1173,551,1732,1061,1457,1733,1165,1007,1005,1009,1013;21;M
21223;1005,1007,1009,1013;38;F
21226;1005,1007,95,1009,1013;32;F
21236;1005,1007,1009,1013;14;F
21421;95;55;M
21635;609,1061,1743,1732,1059;39;M
21745;1007,1005,1009,1013;11;F
21772;1005,1007,1009,1013;10;F
21794;1062,1733,1743,1732,1019,551,1298,195;37;M
22083;954,1062,551,1059,972,1457,1733,609,549,1019,1743;54;F
22129;1169,954,549,1178,1732,1743,904,1059,551,1019;31;F
22230;1742,954,1062,591,1173,1160,551,546,972,1459,1061,549,1743,904,1019;30;F
22428;904,1059,551,549,609,1457,1061,1743,1459,972,1019,591,1062,1742,954;43;F
22430;546,1061,904,1060,1733,609,95,439,1160,1038,1178,1743,1732,1019,1062;64;F
22432;609,1733,1005,1061,1743,95,904,1019,1742,1169,546,1059,1062,1060,551;37;F
22547;1399,95,1005,1007,972,551,1019,973,1173;33;F
22640;1169,1165,904,1059,439,551,1062,954;29;F
22876;1732,1742,195,549,1743;37;F
22974;1178,1165,1459,1399,195,1062;47;M
22992;549,1178,972,95,1060,551,591,1062,1742;28;F
23103;1008;48;F
23117;1178,549,1298,1743,1742,1062,546,1008,439,551;42;F
23284;1169,1743,1062;30;F
23756;1038,1160,195,1059,1008,95,1459,1732,1743,1169,1733,904,1060,551,954;13;M
23775;549,1298,1169,1061,1732,95,904,1019,1742;30;F
24009;95;48;F
24090;1743,972,1060,1059,1742,904,95,954;54;F
24123;1298;39;M
24135;549,1733,1743,1732,546,1459,195,1742;24;M
25063;954,1061,549,1457,1743,1732,1459,546,1399,1060,1008,439,1019,1038,1742;32;M
25267;1743,972,1742;30;F
25468;95;47;F
25586;1732,1742;69;F
25607;904,1742,551,1008,1009,549,1061,972,95,1060,1059,1019,1038,1013,1062;4;F
25638;546,95,904,549,1178,1298,1169,1061,1743,1732,1459,1059,195,973,1742;33;M
26182;1013,1007,1005,1009;33;F
26208;1005,1007,1009,1013;38;M
26341;1457,1060,549,95,1059,195,1173,1742,1169,1733,1743,1459,972,904,954;20;F
26421;95,1732,1005,1007,1061,546,1009,1059,973,1013,1062;48;F
26511;1743,1008,973,1173,1742,1005,1007,1061,1732,546,1009,1059,1160,1013,1062;52;M
26527;1062,1005,1007,1009,1013;35;M
26690;1005,1007,1009,1013,973;44;M
26729;973,1061,1005,1007,1009,1013;44;F
26784;1178,609,1733,1459,1399,195,1062,549,1743,1742,1732;46;F
26931;1060,1732,1178;31;F
26952;1060,1173,1062,954,1742,1038,195,439,1459,1732,549,1169,1457,1743,904;35;F
27054;1298;45;M
27097;1009,972,439,551,1019,1038,591;46;F
27160;954,95,1060,1005,1007,1061,546,1059,973,1013,1062;44;M
27319;1061,439,1019,1062,1178,1457,1743,1732,972,546,904,1060,1008,1059,954;55;F
27485;1160,591,1062,1019,1060,1459,1457,609,549,1743,546,439,551,1173,1742;44;F
27831;1459,549,1169,591,1019,551,1399,972,1743,1733,1165,546,439,1173,1062;40;F
27966;1178,1733,972;64;F
28175;1178,1298,1165,1059,551,1173,954;37;M
28342;1009,1019,1298,1005,1169,1743,1061,1173,549,1733,546,1059,439,1062,1742;24;M
28364;904,1733,1178,549,1169,1165,1457,1743,1459,546,1399,1009,551,1742,954;24;M
28482;1059,1743,1459,1742,549,1457,439,551,195,1160,954,904,546,1169,1733;36;F
28962;1298;51;M
29050;1459,1178,1169,954,551;21;M
29837;904,95,546,1733,1459,549,1457,1743,1732,195,1062,1742;42;F
30103;1457,1298,549,609,972,546,1165,1743,1732,1459,1399,195,1173,1062,1742;41;F
30126;549,1743,1062,1742;69;F
30612;546,1743,1742,549,1169,1059,439,551,1173;45;F
30697;1165,546,439,551;41;F
30720;954,1013,973,95,1061,1169,1298;24;F
31008;1743,609,1005,1007,1013,973,1019,1059,1009,1060,904,95,546,1732,1061;71;F
31018;1298;16;F
31129;954,1742,591,1173,195,904,972,1457,1733,549,1732,1743;73;F
31168;549,1743,1459,1059,195,1742;68;F
31264;546,973,954,1005,1007,1061,95,1009,1013;66;F
32509;195;69;F
32513;1298,591,1165,1457,1061,1459,972,546,1399,1059,551,1019,1062;39;F
32564;1007,1005,1061,95,1013,973;47;M
32856;972,1399,1733,1059,551,195,973,1742,1178,549,1457,1743,1732,1459,1165;73;F
32904;1733,1732,1459,1062,439,1019,195,591;42;M
32970;1009,1060,439,551,591,1062,1005,1007,1061,95,1059,1019,1038,1013,954;38;F
32989;1459,1399,1008,439,1173,1062;29;F
33095;591,551,1005,1007,1061,546,95,1060,1059,1013,1062;51;F
33253;1298,1005,1007,1061,546,95,1060,1059,551,1013,1038,591;48;M
33526;546,1178,1457,1019,1013,591,954,1298,1169,972,1008,1059,551,1160,1173;42;F
33588;549,972,904,1742,973,1743,1178,1165;52;F
33728;1061,1733,904,1457,1160,549,1743,1459,1399,195,1173,1742,1178,1165,1732;38;M
33880;1733,549,1298,1165,1061,1743,1732,1459,972,546,1399,195,1173,1062,1742;45;M
33929;1457,1733,609,549,1298,1165,1743,1732,1459,546,1399,195,1173,1062,1742;15;F
33964;549,1298,1165,609,1733,1743,1732,1459,972,546,1399,195,1173,1062,1742;12;M
33972;1160,591,1742,954,1178,549,1298,1169,1165,1733,1061,1743,1732,904,1173;40;F
34026;1178,1062,1060,1298,972;43;F
34274;954,1019,1733,1007,1005,1298,1061,1743,1732,546,95,1060,973,1013,591;57;F
34362;1169,1059;33;F
34367;1298;38;M
34451;546,1060,551,1457,1298,1059,1062;43;F
34458;546,1062,1298;39;F
34473;1298;47;M
34599;439,1160,1038,954,591,1742,549,1743,1459,95;42;F
34605;195,1019,439,904,1459,1743,549,1178,1298,1169,1733,1457,546,1060,1059;41;F
35039;439,195,1160,1062,1169,1178,1060,973,1038,1173,1742,1061,1459,1743,549;23;F
35278;1742,1732,1062,609,904,1009,1059,1005,1169,1007,1061,95,973,1013,954;51;F
35297;1038,1060,972,1007,95,1009,1059,1013,954,1169,1005,1061,1062,546,973;44;M
35316;1165,609,1733,1743,1399,1742,1178,1298,1459;59;M
35696;1005,1007,1009,1013;48;F
35826;1742,1062,1160,549,1165,1732,1169,1743;34;M
35939;1013,1007,1005,1061,1060,1059,1062;62;F
36192;1298;46;F
36483;1178,1007,1165,609,1733,972,546,1060,439,551,1019,1038;82;F
36758;904,1173,439,1059,1399,1459,1743,1457,1178,1298,1169,1062;41;F
36770;95,1060,1038,1742,549,1733,1457,1061,1743,1732,1062,904,973,1169,1005;48;F
36809;95,904,1009,1173,1062,954,1178,1298,1169,1733,1457,1743,1732,1459;54;F
36966;95;81;M
37757;1743,1732,1459,973,954,1742,549,1178,195;64;M
37838;1743,1742,549,1169,1459,1732,1298;37;F
37945;1742,1059,904,546,609,1298,972,1019,1038,591,1169,1005,1007,1009,1013;36;F
38001;546,551,1178,609,972,1019,1062;42;M
38508;1742,591,1173,1019,1060,1178,1005,1007,1061,1743,95,1009,973,1038,1013;15;F
38969;1178,1005,1007,1061,1743,1459,95,1060,1009,1019,973,1038,1173,1013,1742;11;F
39739;195;73;M
39841;1732,1165,1169,549,1005,1298,1007,1733,1009,1059,439,1013;3;F
39898;1298,1005,1007,1733,1009,1059,1013,1062;5;M
39924;195,1160,1742,954,1005,1007,1457,1732,546,95,1009,973,1013,1061;66;F
39926;1298,1005,1007,1009,1059,439,1013,1062;7;M
39960;1178,549,1298,1005,1169,1007,1733,1009,1059,1173,1013,1062;11;M
39967;549,1178,1298,1169,1733,1457,1743,1732,1459,95,904,195,1060,973;54;F
39973;609,1169,1178,549,1298,1005,1007,1009,1059,1013,1062;14;M
39989;95,904,1008,439,1160,1013,1062,1169,1733,1061,1732,1399,546,973,954;68;M
39991;549,1298,1005,1169,1007,609,1009,1059,439,551,1160,1013;16;F
40002;1019,439,609,972,195,954,1733,1298,1178,549,1743,1732,546,1062,1742;30;F
40351;439,1459,549,609,1732,1743,546,1059,551,1742;39;F
40356;1060,1008,551,1013,1062,1005,549,1298,1007,1457,1061,1732,1009,1059,973;7;M
40360;1459,972,439,1173,1457,1019,549,1298,1743,1732,546,1059,551,195,1742;40;M
40452;1005,1007,1009,1013;10;M
40595;1038,1019,954,972,1007,1062,591,551,439,1169;64;M
41033;1038,954,1178,1298,1169,1059,439,551,1019,1062;34;F
41066;973;45;M
41165;1733,1169,1008,1160,546,439,1062,954,549,1743,1732,1459,904,195,1742;50;F
41258;1007,1457,95,551,954,195,904,972,1459,1732,1169,1743,1298,549,1742;20;M
41270;1005,1007,1009,1013;45;F
41478;1743,1062,591,1008,972,1061,1178,973,1160;40;F
41733;1062,1038,1173,439,1008,904,546,1732,1743,1298,1169,972,1060,551,1019;27;M
41882;549,1298,1005,1169,1007,1165,1733,1743,1732,546,95,904,1008,1173,1013;40;F
41893;1298,549,1165,609,972,1019,1038,591;42;F
42157;95;46;F
42419;95,551,1008,1059,1160,1173,1457,546,591,1062,609,972,1060,1019,1038;64;F
42464;546,1062,1742,195,1019,439,972,1459,1732,1743,1457,549;46;F
42476;1005,1007,1009,1013;53;F
43277;1457,1743,1459,1399,954;31;F
43417;1005,1007,1009,1013;61;F
43514;1005,1007,1009,1013;37;F
43528;1005,1007,1009,1013;12;F
43543;1005,1007,1009,1013;10;M
43557;95,1457,1019,904,1399,1459,1165,1743,1732,1059,195,1160,1173,1742,954;43;F
43567;1005,1007,1009,1013;2;F
43580;1005,1007,1009,1013;14;M
43585;1005,1007,1009,1013;8;M
43594;1005,1007,1009,1013;5;M
43603;1005,1007,1009,1013;42;M
43625;1008;43;M
43711;1457,1743,1459,546,1399,551;34;M
43774;954,904,1459,1732,1169,549,1743,1060,1059,551,1019,195,1742;48;F
44059;954,195,1019,904,972,1732,1743,1457,1733,549,1742,1062,1060;36;M
44127;1061,1298,1178,609,1733,904,546,439,1019,1160,1013,591,1062,954;18;F
45042;1459,1019,973,1173,1007,1060;46;F
45112;1743,904,1062,1742,549,1169,1173;37;F
45161;1005,1007,1009,1013;23;F
45221;551,972,1732,1743,1457,549,1169,1733,1459,546,95,904,1173,1742,954;23;F
45390;1008;53;F
45409;1008;25;F
45419;1008;27;M
45432;1008;54;M
45797;1005,1007,1009,1019,1013;9;M
45930;1007,1178,609,1457,1459,1399,904,1060,1059,1019,973,1160,1173,1062,954;48;F
46054;1178,609,1457,1459,1399,904,1060,1059,1019,973,1160,1173,1062,954;48;M
46142;972,546,1059,1062,1060,551;41;F
46588;1298,1005,1007,1061,1732,546,1060,1009,1008,1059,551,973,1013,1062,954;5;M
46835;591,1008,1743,972,549,609,1732,546,1399,439,1019,1062;17;F
46973;1457,904,551,1019,1178,1298,1169,1061,1743,1732,546,1060,439,1038,1062;64;F
47171;972,1732,1060,1061,1059,1062;38;F
47194;1061,1060,1059,1062;11;M
47220;549,1061,1060,1059,1062;8;M
47390;1457,972,1399,1060,1019,195,1038,1742,549,1298,1165,1743,1059,1173,1062;31;F
47475;195;51;F
47539;549,1298,1457,1743,1732,95,904,1059,195;27;F
47882;1399,551,1059,1178;41;F
47915;1008;9;F
47949;1457,904,195,954,549,1169,1007,609,1743,1732,1459,972,1399,1059,1742;23;F
48006;1019,1298,1733,546,954,1732,904,1173;45;F
48577;1399,904,439,195,973,1160,591,1062,1742,954,1178,1457,1743,1732,1459;48;M
48763;1005,1007,1009,1013;35;F
48881;1005,1007,1009,1013;64;F
48939;1005,1007,1009,1013;61;F
48988;1005,1007,1009,1013;36;F
48997;1005,1007,1009,1013;42;F
49084;1005,1007,1009,1013;62;F
49198;1005,1007,1009,1013;59;F
49286;1005,1007,1009,1013;37;F
49315;1005,1007,1009,1013;14;F
49324;1005,1007,1009,1013;14;F
49375;1005,1007,1009,1059,1013;49;F
49396;1005,1007,1009,1013;57;F
49445;1005,1007,1009,1013;66;F
49499;1005,1007,1009,1013;64;F
49522;1005,1007,1009,1013;61;M
49529;1298,1165,609,1732,972,904,1019,1038,591,954,1733,546,439,551,1062;37;F
49554;551,1005,1007,1009,1013;8;F
49755;1005,1007,1009,1013;46;M
49969;1013,1298,1165,1459;26;M
50075;1005,1007,1009,1013;41;F
50094;1178,973,954;60;M
50097;1399,972,1732,1165,1733,546,904,1059,439,551,1019,1038,591,1062,954;7;F
50103;1005,1007,1009,1013;19;M
50118;1005,1007,1009,1013;17;M
50120;1165,1733,1732,972,546,904,1060,1059,439,551,1019,1038,591,1062,954;10;F
50130;1165,609,1733,972,546,904,1060,1059,439,551,1019,1038,591,1062,954;9;F
50132;1005,1007,1009,1013;15;F
50141;1005,1007,1009,1013;10;F
50143;1160,1165,609,1733,1732,972,546,904,1059,439,551,1038,591,1062,954;5;M
50146;1178,973,954;88;F
50156;1005,1007,1009,1013;4;M
50170;973,954;93;M
50174;1005,1007,1009,1013;;M
50181;549,1169,1457,1743,1732,1459,972,546,1060,551,1019,591,1062;38;F
50184;1060,1059,1038,1169,609,1733,1743,1160,1173,1742,549,1732,1008,1019,1062;18;F
50282;1178,973,1007,1005,1009,1013;40;F
50325;1459,1062,609,551,195,1742,1169,1743,1173,549,1165;41;F
50371;549,546,1038,1298,609,1733,1061,972,1399,1019,1160,1173,591,1062;43;F
50389;1298,1062,439,546,1165,1457,1061,1743,1459,972,1399,1059,551,1019;37;F
50433;1743;39;M
50462;1059,1005,973,1013;45;F
50464;1005,1007,1009,1013;11;M
50497;1005,1007,1009,1013;36;M
50562;609,1298,972,1019,1062,954;34;F
50652;1060,1457,1733,1013,551,1059,1459,1298,549,1169,609,1743,546,1173,1062;46;F
50691;195,1038,1733,1298,1005,1007,1457,904,439,1173,1062,1742,954;61;M
50728;1399,904,954,1173,1733,546,551,1019;48;F
50863;1298,1005,609,1733,1061,546,95,1060,1059,439,1019,1169,195,1173,1062;24;F
51055;1459,1059,551,1160,1173,954,1298,1165,1457,1733,1743,1732,1060,1019,1169;33;F
51080;1178,549,1061,1459,1732,904,1019,195,1038,591,1062,1742,1743,546,95;38;F
51305;609,546,1160,1742,1732,972,1019,1038,591;43;M
51408;973,439,1061,609,1169,1062,1038,1060,1459,1178,1165,1743,546;37;F
51411;1005,1007,1009,1013;40;F
51448;1005,1007,1009,1013;6;F
51461;1005,1007,1009,1013;4;F
51479;1005,1007,1009,1013;3;F
51571;1005,1007,1009,1013;7;F
51589;549,1005,1743,1732,1459,1173,1742;48;M
51619;549,1169,1165,1457,1459,1060,1019,1062,1743,1732,972,546,904,439,1173;51;F
51637;1005,1007,1733,95,972,1173,1019,1399,1169,1732,1008,439,973,954,1062;47;M
51654;1732,551,954,1038,1062,439,973,1005,1007,1061,546,95,1060,1009,1013;46;F
51789;609,1165,1005,1007,1061,546,95,1060,1009,439,551,973,1038,1013,1062;49;M
51848;1005,1007,1061,546,95,1060,1009,439,1019,973,1038,1013,1062,1742,954;17;M
51859;1005,1007,1061,546,95,1060,1009,439,551,1019,973,1038,1013,1062,954;14;M
51919;1178,1733,1457,1059,1008;36;M
52025;1169,1178,1298,1165,1743,1732,546,1399,1060,1059,551;33;F
52144;439,972,1165,549,1178,1743,1732,95,195,1173,1062,1742;34;F
52238;439,1019,195,1160,1742,549,1743,1732,972,546;50;F
52456;1008,973,1742,1733,1169,954,1298,1178,1457,1743,1459,546,1399,1059,195;39;F
52811;1061,1732,1060,439,1742,1062,1173,973,549,1178,1457,1743,1459,972,195;44;M
52862;609,1061,1060,1062,1038,954,1298,1165,1733,1743,972,546,551,1019,591;42;F
52884;1733,1743,972,1059,1062,1298,549,1165,1457,1732,546,1399,439,551,1742;36;F
52919;1005,1007,1009,1013;10;M
53089;1060,904,1732,1743,549,1178,1062;32;M
53094;1165,1399,1459,1298;37;F
53099;1733,1060,1059,195,1742,546,1732,1743,549,1169,972,551;40;F
53110;1732,972,1399,904,1059,551,1019,973,1173,1178,1298,1165,1743,1459,546;40;F
53113;1059,1173,1038,1060,1061,549,546,954,551,1019;44;F
53117;972,1733,1005,954,1742,1062,973,195,1059,1060,1459,1178,549,1743,904;29;F
53135;1743,1732,1298,1165,1733;44;F
53137;1743,1732,954;37;F
53138;439,1008,95,1459,1061,1165,1298,549,1733,1457,1743,1732,972,904,1742;37;F
53140;1169,1457,1019,1173,1298,972;35;F
53156;1178,1459,1399,1008,1160;44;F
53164;1178,609,1459;43;F
53177;972,1743,609,1007,1165,1733,1732,95,1399,1060,1019,1160,1173,1013,1062;23;F
53186;95,551,1160,1178,1169,1165,1733,1743,904,1060,1059,1298,1732,1173,1742;46;M
53189;1457,1005,549,1062,954,195,1059,904,972,1733,1743,1459,546,95,1399;26;F
53190;1062,972,1457,1733,1298,549,1743,1173,1742;23;M
53191;1165,1178,1733,1061,1743,1732,1459,1060,549,972,904,551,1019,195,1742;41;F
53199;1060,1019,1062,549,1005,1169,1165,1457,1743,1732,1459,1399,195,1173,1742;23;F
53207;1743,1733,1178,1298,609,1165,1732,439,1160,591,1019,546,549,1062,1059;40;F
53210;551,1733,1298,1457,1399,1019,973,1062;41;M
53216;549,1062,1742,1743,904;52;M
53223;439,1038,1005,549,1298,1457,1743,1732,1060,1059,551,1019,1160,1062,1742;31;M
53224;549,1743,904,195,1742;28;F
53230;609,1062,546,195,1019,1038;73;F
53235;1743,972,904,439,591,1062,95,1399,551,1298,1457,1061,1459,1059,954;42;M
53260;1457,1733,609,1459,972,546,1399,1008,1059,439,1019,591,1062,1165,1298;42;F
53269;549,609,1733,1061,546,1059,551,1019,1038,591,1742,1298;42;F
53270;954,1062,904,972,1743,1457,1459,1059,551;42;F
53272;1007,1173,1061,904,1062,1059,95,972,1005,1298;30;F
53279;1038,609,1061,1743,95,904,1060,551,195,591,1298,1169,1457,1459,1059;39;F
53280;95,546,1732,1061,549,1742;31;F
53288;1062,439,551,1173;39;F
53294;1005,1062;42;F
53303;1019,1160,1173,1062,1742,546,1743,609,1165,1169,1298,549,1178,1059,551;41;F
53318;551,195,1743,546,1019,1062;29;M
53323;1298,1165,609,1733,1457,1459,972,546,1399,1008,1059,439,1019,591,1062;4;M
53334;1062,1732,1173;39;M
53342;1298,1165,609,1733,1457,1459,972,546,1399,1008,1059,439,1019,591,1062;15;M
53346;1732,1743,1457,1007,1005,1298,1733,549,1399,1160,1173,591,1062,609,1459;40;F
53353;1298,1457,1743,1059;39;F
53357;1298,1165,609,1733,1457,1459,972,546,1399,1008,1059,439,1019,591,1062;12;M
53360;546,904,439,1019,195,1173,1062,1178,1165,1457,1459,972,1399,1059,551;14;F
53373;1298,1061,1743,972,1059,439,551,1019,1062;47;F
53378;954,1061,1742,973,1732,1743,1457,549,1178,1298;34;M
53383;95,546,1733,549,1298,1169,609,1061,1743,972,1060,439,591,1062,954;40;F
53384;1742,95,1743,1457,1165,549,1298,1169,1732,1459,1399;26;M
53419;954,973,546,1743,1732,1005,1298;20;M
53424;546,1459,1732,1457,1733,1178,1298,1061,1743,972,904,1060,1008,439,1742;41;F
53441;1059,954,1005,904,195,1173,549,1298,1733,1457,1743,1732,1008,1062,1742;31;M
53451;591,1062,1742,195,904,546,972,1457,1169,1743,1732,1060,1059,551,954;32;F
53466;973,1732;33;M
53472;904,551,591,1742,954,1038,1019,1059,1060,1399,1732,1061,1733,609,1005;37;F
53479;1005,1169,1742,591,1173,1160,195,551,1059,1009,904,95,972,1732,1061;47;F
53483;1733,1743,972,1059,1062,1298,549,1165,1457,1732,546,1399,439,551,1742;9;M
53491;1062,1059,972,1743,1733,1298,549,1165,1457,1732,546,1399,439,551,1742;5;M
53502;1062;28;F
53514;1178,1298,1743,1459,1059,551,973;38;M
53524;1298,1059;35;F
53527;1732,904,1060,1059,551,1019,1062,1005,1007,1061,95,1009,973,1013,954;12;M
53549;972,546,1743,1457,1732;32;F
53573;546,609,972,1060,1019,1038,591;38;F
53609;1061,609,1169,549,1178,1743,1173,1165,1733,1732,972,904,1060,1062,954;29;F
53649;954,1742,1061,609,904,1019,1173,1062,549,1169,1743,1732,1459,972,195;36;F
53695;1399,1173,1013,1165,1005,904,954,95,1459,1457,1298,1061,1732,1019,1062;24;M
53750;1178,1169,1165,904,439,1019,1173,1742,1733,1743,1059,551;37;F
53765;1743,904,1019,1173,1062,1178,1169,1165,1457,1459,1399;64;M
53769;1165,1061,1742,954,1062,1060,1459,1732,1743,1178;60;F
53842;1178,1169,1743,1732,1459,546,1060,439,551,1062;41;F
53892;1165,609,1061,1059,973,1038,1060,439,1005,1298,1178,1457,546,1459,1399;14;M
53920;546,95,439,1038,1013,954,1178,1298,1732,904,1060,1059,551,1019,1062;43;F
53948;591,1169,1005,972,551,1062;39;F
53988;551,439,1169,549,1743,1732,1459,972,95,1399,1173,1062;30;F
54000;1061,1459,972,95,1399,609,1019,904,1178,1298,1457,1059,551,195,954;43;F
54005;549,1019,195,1013,1742,972,1059,551,1298,1459,1733,1457,1743,1732,95;26;F
54017;609,1733,1060,1038,591,1062,1178;36;F
54019;1173,1742,549,1743,1160,195,1298,1733,1732,1459,1060,439,1062;30;M
54046;1178,1169,1165,609,1733,1743,1732,972,1060,1059,551,1019,1160,1038,1062;34;F
54077;1059,95,546,972,1732,1743,1733,609,1013,551;34;F
54096;549,1733,1743,972,904,1019,1173,1298,1059,551;38;F
54112;904,1160,1013,973,1009,1298,1005,1169,1007,1061,1732,95,1059,1062,954;25;F
54161;1298,609,1733,1061,904,195,973,954,1178,549,1743,1732,1742;37;M
54267;1007,1169,1459,95,551,1019,1038,591,1298,1733,1457,972,1060,1059;40;F
54268;1298,609,1743,904,1059,551,1019,973,1062;34;F
54289;1160,1169,1165,1743,1732,1060,439,1742;44;F
54297;609,1059;38;M
54304;549,1743,1732,1459,195,1742;47;F
54334;1178,1298,1165,1732,546,954,1062,1173,1160,1019,551,1059,1008,904,972;38;F
54378;1733,1061,1060,1059,973,1062;46;F
54381;549,1743,1732,95,904,1060,1173,1062,954,1742;21;F
54387;1062,954,549,1743,1169,972,1059,439,551,1019;27;F
54394;1178,1733,1743,1732,972,95,1399,904,439,195,1160,1038,1062,1742,954;23;M
54423;1733,1061,1060,1059,973,1062;49;M
54442;1733,1061,1060,1059,973,1062;21;F
54455;1733,1061,1060,1059,973,1062;76;F
54464;1178,972,1061,1743,1732;40;F
54466;1733,1061,1060,1059,973,1062;75;M
54477;1061,1060,1059,1062;18;F
54490;549,1298,1169,1743,1732,972,95,1059,439,1019,1062,1742,546,904,551;46;F
54605;1005,1007,1009,1013;48;M
54645;549,1005,609,1743,1060,195,973,1038,1013,1062,1742;49;F
54646;1013,591,1062,1742,954,1005,1733,1459,972,95,904,549,1298,1743,1732;31;F
54651;1005,1007,1009,1013;48;F
54652;546,1060,1009,1059,439,551,1019,973,1013,1062,1005,1169,1007,95,591;32;F
54653;609,1733,1457,1743,1459,904,954,1169,1732,1059,551,1019,591,546,972;32;F
54662;1457,609,1178,549,1743,1732,1459,904,1060,195,973,591,1062,1742,954;44;F
54672;1298,1169,609,1733,972,546,1059,551,1019,1173;37;F
54678;1178,549,1298,1165,1732,1459,195,1742,1743,972;40;M
54720;1008,1059,439,551,1019,195,1160,1038,1173,1013,1062,1742,1165,1298,954;43;M
54723;1733,1165,1178,1298,1457,1061,1459,972,546,1399,904,973,1160,1173,549;15;M
54727;1178,1298,1169,1457,1743,1732,1459,195,1062,1742;63;F
54761;549,1007,1061,1743,1742,954,904,551,195,1013,1733,1457,972,546,1059;31;F
54937;1007,1743,1060,1038,1062,1742;64;M
54967;549,1178,1061,1743,1732,1459,972,439,973,1062;36;F
55016;1399,904,1019,591,1038,1173,1060,439,1062,1165,1298,1743,1732,546,551;38;F
55070;1742,1459,549,609,1743,1732,972,546,1060,439,1019,1160,1173,591,1062;47;F
55074;1178,1298,1457,1459,1173,1062,1742,549,1733,1743,1732,546,972,1399,1008;25;F
55082;1165,1457,1732,904,1060,1059,551,1173;30;F
55090;1178,1165,609,972,546,1399,954,1038,1173;33;F
55092;1005,1007,1009,1013;43;M
55094;1178,1165,1743,1459,972,546,439,551,195,1742,1399,1059,973,1173,1062;33;M
55101;549,1298,1457,1459,546,95,1399,904,439,551,1160,1173,1062,1733,1743;50;F
55134;1178,1298,1743,439,1160,1173,1169,1061,95,904,1060,1059,1019,591,1062;34;F
55145;549,546,95,1399,591,1062,973,195,1059,1459,1743,1457,609,1178,1169;33;F
55159;1062,1178,1743,546,973,1038;71;F
55171;1169;35;F
55188;95;56;F
55214;1399,546,1178,1743,1459,195;20;M
55248;1008,95,1459,1457,1733,1178,1298,609,551,1019;45;F
55260;1173,954,591,1062,1038,439,1008,904,546,972,1732,1457,1733,1007,1169;42;F
55305;591,954,1038,551,549,1743,546,95,1399,1742,1298,1457,1060,1008,439;53;F
55307;1061,1019,1173,591,1062,1742;42;F
55385;1298,1160,1008,1009,1059,95,1732,1733,1169,1007,1005,1061,904,973,954;55;F
55439;1019,1160,1005,1061,95,1009,973,954;56;M
55455;1178,1742,1732;52;M
55617;972,1008,551,1038,954,609,1733,1061,95,1060,1059,439,1019,973,1062;23;F
55748;551,1457,1060,1059,195,1459,1061,1733,549,1743,1732,1062,1742,1165,1298;39;M
55756;1178,1459,195,549,1743,1742;50;M
55759;973;31;M
55882;549,1459,972,1059,1062,1178,1298,1169,1165,1733,1457,1743,1732,1399,1742;30;M
56056;972,609,1019;46;F
56070;549,1733,1457,1743,1732,1459;30;M
56080;973,954;31;M
56083;954;51;M
56092;1733,1743,1732,1060,551,439,1019,1038,591,1062,1008,904,546,972,609;59;F
56372;609,1165,549,1005,1743,1459,439,1019,973,1742,1178,1169,1062,954;38;M
56383;1013,1062,954,546;34;F
56533;904,1399,1457,1733,609,549,1298,1165,1743,1459,972,1060,1059,1173,1062;38;M
56552;95,1061,1178,1298,1743,546,904,1019,1013,1169,1165,1732,1459,1399,954;46;M
56645;1298,95,549,1169,1743,904,1060,551,1059,1019,954,1742,1038,591,1062;31;M
56656;1742,439,1732,1743,609,1178,546,1059,551,591,954,1165,1733,972,195;39;F
56897;1169,973,1062,95;56;M
56920;1062;23;F
56924;1160,1298,1399,904,195,1457,549,1178,1742,1459,546,439,551,973,954;34;F
57302;1165,1169,1178,549,1743,1732,1399,1060,1008,439,1019,195,973,1173,1062;26;M
57423;1061,1059,1038,195,609,1298,549,1743,972,1019,591,1062,1742,546,551;37;M
57496;1457,1743,1732,546,904;62;F
57583;1743,1178,1732,1459;48;F
57674;1298,609,1743,1059,439,551,1019,1160,1038,591,1062;36;F
57680;549,1457,1743,1732,1459,195,1742;30;F
57705;1298,1165,609,1733,1457,1459,972,546,1399,1008,1059,439,1019,591,1062;47;M
57723;609,1298,549,1178,1733,1005,1169,1007,1061,546,95,1060,1009,973,1013;33;M
57734;1019,551,439,1059,1008,1009,1061,1005,1298,1169,1007,973,954;34;M
57760;549,1733,1459,546,551,1160,954;33;F
57779;1005,1007,1009,1013;60;F
57867;439,1059,546,1457,1007,609,1743,1019,1062,954;43;F
57948;95;29;F
58072;1459,1743,1733,609,1298,972,546,1019,973,1173,1062,1178,1169,439,1160;40;F
58083;1169,1399,1160,551,546,1459,1732,1178,1165,972,439,1019;62;F
58095;1743,1008,954,1298,1165,1733,1732,972,1399,904,1060,1059,439,1173,1062;30;F
58108;549,1298,1165,1743,195,1038,1742,1062,1732;30;M
58312;591,1742,1165,1732,972,904,1060,551,1019,549,1169,1743,1059,954,1173;35;F
58563;1178;30;F
58569;1457,609,1178,549,1298,95,904,1008,551,1019,1062,1742,1169,1060,1059;38;F
58889;904,1038,972,1459,195,549,1169,1732,1743,546,439,1059,551,1742;37;M
58903;1005,1007,1009,1013;43;F
58917;1019,1165,549,1169,1732,1743,1459,972,546,1059,439,551,195,1038,1742;7;M
58918;1005,1007,1009,1013;19;M
58926;1005,1007,1009,1013;17;M
58932;1005,1007,1009,1013;14;M
58937;1005,1007,1009,1013;10;M
58940;1005,1007,1009,1013;7;F
59006;972,904,549,1169,1459,1743,1732,546,1059,439,551,1019,195,1038,1742;2;M
59021;1019,1160,551,1060,1173,546,1743,609,549,1178;38;F
59049;1169,1062,1173,1743,1165,1178,1298;41;M
59080;1399,904,1742,1178,1743,1459,195;74;F
59096;1005,1007,1061;38;F
59107;549,1732,1019,1038,1742,1298,954,546,904;34;F
59195;972,1732,1013;41;F
59196;1298,1733,439,609,972,546,1173,1038,1060,1059,551,1019,591,1062,1742;38;F
59323;904,1169,549,1399,1062,195,1459,1743,1178;28;F
59620;1062,1038,1733,1732;70;M
59693;1457,1743;39;M
59835;954,1007,1061,1005,1732,546,973;53;M
59981;546,1732,1060,1062,1742,1743,1733,1298,549;43;M
59982;1298,1733,1457,1743,1732,1459,95,1399,1060,1059,439,195,1038,1173,1062;34;F
60139;1013,1062,954,973,1060,904,546,972,1459,1732,1059,551,1019,1038,591;38;F
60145;1459,591,1062,1298,1743,1732,972,1019,954,904,1399,1059,546,439,551;33;F
60233;546,1743,1457,1732,1733,1298,1178,1165,609,1459,972,904,1173,954;44;M
60329;1005,1457,551,591,1062,1019,1059,546,1732,1743,1061,1733,1165,1298,972;42;F
60350;904,972,1732,1169,1165,546,1059,1173;40;F
60410;1007,1013,1005,1061,1059,973;38;F
60489;954,1062,551,1038,1019,1059,1060,546,1743,1298,1061,972,904,1008,439;47;M
60691;1060,904,551,954,1059,95,1459,549,1457,1019,195,1742,1733,1743,1732;54;F
60805;1459,954,1742,591,1038,439,1059,1457,549,1298,1061,1743,1060,1173,1062;37;F
60833;549,1743,1399,1173;72;M
60940;1743,972,551;44;F
61016;1060,546,1459,1061,1733,609,1007,1178,1062,1013,973,439,1008,972,1005;19;M
61063;1038,591,1165,1457,1742,609,1169,1733,1743,439,1019,1062,1059,546,551;45;F
61077;549,1733,1457,1399;42;M
61136;1059,1061,551,1178,1298,546,1399,973,549,1457,1732,1459,195,1742,1743;48;M
61562;549,1169,1743,546,609,1732;32;F
61601;1059,1038,1062;45;F
61704;1062,973,1059,1005,1007,1061,95,904,1060,1009;43;F
61837;972,1732,549,1399,1059,973,1173,1178,1298,1165,1733,1743,1459,546,1160;32;M
61850;1178,1165,1399,1060,1059,439,1062,1019,973;34;F
62005;1399,904,1059,1019,973,1062,1742,1459,972,1060,195,954,1298,1178,549;35;F
62008;1178,609,1743,1732,1459,972,95,1399,904,439,195,973,1160,1173,1062;32;F
62087;1008,1059,439,551,1019,195,973,1160,1038,1013,1173,591,1062,954,1742;30;F
62306;972,1298;44;M
62310;1298,972,1019,1062;14;M
62424;1178,609,1061,904,1160,1019,551,1060,546,972;48;F
62450;1733,1457,1060,195,1173,1742,954,549,1743,1732;30;F
62471;1173,1457,1459,546,1399,551;40;F
62488;1061,1059;38;F
62669;546,1165,1743,1059,551,1062;38;M
62733;1742,1013,195,439,1059,1732,1743,1007,1005,1061,95,1060,1009,973,1062;50;F
62927;1178,1160,95,1165,1169,1298,1457,1743,1459,1399,904,1060,1059,1173,1062;36;F
62941;549,1743,546,551;48;F
63142;1178,549,1743,1732,1459,1060,1059,551;71;F
63219;1733,439,1457,1173,1062,551,1059,1732,1169;38;M
63274;549,1743,546;79;F
63389;1013,973,439,1060,1399,1457,549,1733,1743,1732,972,1008,1059,1019,1038;38;F
63802;1399,591,1743,904,439,1038,1062,1019,1732,1733,1178,546,551,954,1742;58;F
63961;1059,551,1038,1005,1061,904,1173,1298,1732,1060,1008,439,1019,1062,954;28;F
63999;549,609,1733,1743,1732,972,1160,1038,1019,195,591,1062,1742;50;F
64095;1005,1007,1061,95,973,1013,591;54;F
64122;1005,1007,1009,1013;72;F
64124;546,1062,1733,439,1005,1007,1061,1732,95,1009,973,1013,954;70;F
64175;1005,1007,1009,1013;32;F
64247;549,1298,609,1733,1743,1732,1459,546,1399,551,1019,195,1160,1173,1062;24;F
64249;1038,195,1732,1743,1061,1178,1005,95,1013,954,973;40;M
64348;1005,1007,1009,1013;28;F
64555;1298,549,1732,1743,1742,195;23;M
64696;1061,1459,1009,1019,1013,1742,1007,1457,95,973,1062,1005,1059;42;M
65216;1173,1733,1059,1061,1732,1459,1165,972,546,439,551,1019,1038,591,1062;34;F
65675;1062,1019,1298,1743,972,1059,1038;49;M
65736;1038,591,1178,549,609,1733,1732,1060,1062,1742,1173,1019,95,1459,1061;32;F
65975;1061,591,1733,1007,1742,549,1298,1743,1732,1060,546,1059,439,551,1062;37;M
66190;904,1062,1178,1298,1457,1459,1399,1059,551;39;F
66200;1062,1005,1009,973;47;F
66276;1059,439,954,904,1732,1169;18;F
66370;1459,973,1178,1169,1298,1733,1457,546,1399,1019,195;42;F
66394;1165,1399,1173,1062;33;M
66402;1732,1160,1742,1169,1165,1733,972,95,1059,551,195,1173,591,1298,1061;32;F
66485;609,439,1038,591,551,1009,954;44;M
66535;609,1743,95,439,1062,1732,1061,1005,1059,973;46;M
66715;1732,195,973,1178,549,1165,1743,1459,1399,1173,1062,1742,1298;33;M
67261;1743,1173,1062,1742,1298;36;M
67307;1173,1742,549,609,1743,904,1008,1059,1160,1062,1298,1169,195;29;M
67592;1059,1007,1061,195,1005,1009,551,1038,1013;43;F
67603;1007,609,1061,95,1060,1059,551,1019,973,1038,591,1062;64;F
67634;1742,549,609,1743,1732,1019,954,972,904,551;24;F
67942;1399,1459,1457,1165;45;M
67996;1742,973,1459,549,1743,1061;20;F
68037;1178,1298,1165,1160,954,1732,972,973;17;M
68139;1165,549,1732,1743,1173;41;F
68208;195,1742,549,1007,609,1733,1743,1732,546,1059,551,1019,591,954,95;48;F
68225;549,1742,1743,1178,1169;52;M
68229;1165,1457,1459,1399;14;F
68236;551,1733,549,1169,1743,1732,546,195,1742;33;F
68376;1165,1457,1459,1399;15;F
68433;1165,1743,1173;34;F
68441;1160,609,1061,1743,95,1399,1019,1178,1733,1732,972,546,439,1038,1062;28;M
68465;1457,1459;38;M
68468;1743,1459,972;41;F
68469;1733,972,546,609,1298,1005,1007,1060,1059,439,551,1019,1038,1062;39;F
68470;1165,1178,1298,1457,1459,1399;37;F
68520;1178,1399,1459;45;F
68532;1399,1038,1062,1178,1459,1457;10;M
68559;551,1459,1399;36;F
68568;1178,904,609,1733,1743,1459,972,546,95,1060,439,1019,1160,1038,1062;64;M
68597;1457,1459,1399;38;F
68606;1019,1457,1459,1399;11;F
68629;1457,1459,1399,1059;6;F
68638;1457,1459,1399;43;M
68647;1062,1743,1165,1169,1457,1459,1399;38;F
68693;1298,1165,1399,1160,1173;15;M
68822;1005,1061,1743,551,1173,591,1742,439,95,1178,1165,1062,1457,1459,1399;38;F
68845;1298,1457,904,546,1059,551,195,1742,1399;43;M
68893;1005,1007,1009,1013;3;M
68936;1005,1007,1009,1013;55;M
69039;1178,1733,1298,1007,609,1457,1061,1459,972,1060,1059,1019,1038,1173,1062;51;F
69171;1742,195,1459,1732,1743,1169,549,1298,546;40;M
69192;1743,546,1019;66;F
69401;904,1019,1173,1062,1165,1298,1742,591,195,1732,1743,549,1459,546,551;44;F
69425;1160,1019,546,972,1732,1743,1165,1298;43;M
69488;1059,1060,972,1169,1178,549,1298,1005,1165,1743,546,904,551,1019,1173;9;M
69739;551,1165,609,972,1019,1160;67;F
69792;1298,1165,1743,1732,972,546,1019,1160,1038;40;F
70053;1298,1165,609,972,546,439,1019,1160,1038,591,1062;28;M
70113;549,1457,1732,546,904,551,973,1160,1173,1062,954,1178,1733,1743,1459;46;F
70356;549,609,1457,1459,546,1019,1038,1173,1742,1169,1732,1060,439,551,1062;64;F
70363;1732,1061,1165,1298,1733,1178,546,1399,551,439,1019,1160,1062,1059,1457;75;F
70450;1169,1165,1733,1160;32;F
70490;1399,1173,1742,1038,1298,1457,1061,1743,1459,546,1060,1019,1059,551,1062;33;F
70534;1060,1059,591,1062;63;M
70594;1005,1007,95,1059,973,954;43;F
70648;1061;69;F
70696;609,1733,1459,551,1060,1178,1169,546,439,1019,195,1038,954;12;F
70729;1061,1062,972,439;34;F
70735;195,1060,904,549,1178,1165,1743,1732,1019,1038,1062,1742;41;F
71032;1007,1009,1062,1742,954,1013,904,1178,1732,972,95,1059,551,1019,973;45;M
71088;1742,546,1459,1732,1743,1733,1169,1005,95,1399,904,1060,1019,1059,954;40;F
71152;1005,1007,1009,1013;29;M
71189;972,1173;29;F
71226;1059,551,1062,1178,1169,1743,972,1019,1173;44;M
71229;1062,954,1008,546,1459,549,1743,1732,195,1742;54;F
71384;1399,1457,1459;38;F
71407;972,1459,1732,1743,1457,609,1169,549,1165,1178,1399,1059,439,1173,1062;24;M
71459;1732,1062,95;33;M
71489;1019,904,1059,1062,1742,1457,549,1298,1169,1733,1732,551,1743;46;F
71514;1060,551,1059,1298,1178;37;F
71515;591,546,1457,609,1165,1178,1298,549,1399,1008,439,1019,1062,954,972;30;F
71527;1062,1733,1061;25;F
71729;904,1059,439,1019,1038,1742,1743,1165,1178,1298,1005,973,1173,1062,954;18;M
71781;1165;34;M
71782;1013,439,1060,1005,549,591,1298,1743,1732,972,546,1008,551,1019,1062;44;F
72136;1298,1005,1169,1457,972,904,1008,439,1062;38;M
72187;1298,1733,1732;45;F
72264;904,1060,1062,1005,973,1013,1061,95,1059;53;F
72303;904,1009,1008,1059,1742,546,1733,1169,1165,1173,1160,1459,1298,1019,1062;27;M
72426;1743,1732,972,95,904,1059,551,1019,1733,1459,546,195,1742,1298,549;35;M
72439;1298,1733,1060,1059,439,1038,1173,1062;41;M
72468;549,1298,1743,1732,195,1742,1062;37;F
72477;609,1061,1743,904,1169,1019,195,1062,1742;49;F
72561;1298,1169,1061,1743,972,904,1019,1062;31;F
72643;1005,1007,1169,972,1009,551,1019,1013,591;7;F
72645;1005,1457,1732,546,904,1059,551,973,1742,954,1178,1743,1459,1399,195;50;M
72646;1742,1019,546,1743,609,1178,1165,1062,1173,972,1060,1059,439,973;47;F
72776;95,546,1459,1732,1743,1457,1733,609,1178,549,973,1160,591,1742,1061;24;F
72864;1178,1298,1457,1459,1399,904,1059;35;F
72923;1173,1459,1743;37;F
73018;954,1742,1062,195,1019,1459,549,1298,1743;27;F
73024;1005,1007,1009,1013;53;M
73036;1005,1007,1009,1013;12;F
73107;1169,1733,1732,1459,95,904,1013,1062,954,1005,1007,1061,1009,1059,973;43;F
73121;1005,1007,1009,1013;20;F
73163;546,551,1062,1060,1038,954,1005,1007,1165,609,972,1009,1019,591,1013;65;F
73167;1005,1007,1009,1013;22;F
73202;954,1013,973,1059,1009,904,95,1459,1732,1061,1733,1007,1169,1005,1178;6;F
73332;609,549,1169,1733,1038,1007,1061,546,95,904,1060,1009,1059,973,1013;38;F
73382;1457,1062,195;42;F
73398;954,1160,1019,1059,1060,904,1399,1459,1732,1061,1733,1007,1165,1743,546;53;M
73498;1005,1009,1013;40;F
73601;549,1743,1742,1178,1732,546,1060,439,551,1019;77;M
73624;1169,1013,1173,1178,1298,1733,1457,1743,1732,1459,1399,904,1160,1062,1742;24;F
73818;591,1038,1059,1060,1732,1743,1062,551,439,904,546,1298;32;M
73824;1399,546,972,1733,609,549,1298,1457,1743,1732,1459,439,1019,1062,591;40;F
73990;1178,1298,1061,1743,1459,1399,1060,195,1062;37;F
73999;1005,1169,1007,972,1009,551,1019,1013,591;6;M
74043;1061,972,1013,195,1007,95,549,1005,1733,1732,1742,1743,904,439,954;32;F
74048;973,546,1459,1732,1178;42;M
74156;95;52;F
74358;1005,1169,1007,972,1009,1019,1013,591;;M
74479;95,549,954,1013,1038,551,439,1059,1732,1743,1169,1005,1007,1061,1060;12;F
74505;1743,549,1298;35;M
74513;1062,1007,1005,1009,1059,954,973;44;M
74574;1169,1061,1732,1399,1019,1742,195,551,439,1038,1062,904,546,1733,609;48;F
74584;1005,1061,546,95,1059,973,1013,1062;43;F
74610;1005,1007,1061,546,1059,973,1013,1062,954;44;M
74621;1061,1059,1062,439,1743,1742,1160,195,1457,549,1298,1005,95,546,1399;20;M
74628;195,1169,609,1733,1061,1732,1459,546,904,439,551,1038,1173,1742,1062;50;M
74636;1060,1732,1005,1169,1007,1061,546,95,904,1009,1059,1019,973,1013,1062;7;F
74732;1743,95,1742,1732,546,439,1062;43;F
74797;546,1743,1169,549,1061,1732,95,904,1060,1059,551;38;F
74873;1062,1160,195,1059,1732,1743,1733,609,1298,1178,972,904,439,1019,1038;36;M
74882;1061,1743,1732,95,439,1059,551,1009,1178,1007,1005,973,1013,1062,1742;43;F
74929;1298,1061,1743,972,1008,1059,551,1019,1160,591,1062;39;F
75004;1742;17;F
75077;1007,1165,1061,1743,546,904,1059,973,195,954,1742,1178,1459,1399,1062;21;M
75078;195,549,1298,1005,1457,1743,1459,1732,95,972,1059,551,1019,1062,1742;65;M
75122;1008,549,1169,1733,1457,1743,546,1399,1059,551,1742;46;F
75327;95,1061;90;F
75512;1008,1160,1178,1732,1399,904,1173,1742,973,1459,1743,1457,1733,1169,1298;26;M
75517;1178,1169,1165,1399;33;M
75613;1019,1038,1013,1062,1008,904,195,591,1742,954,549,1298,1169,1732,972;74;F
75689;1178,954,973,1459,95;28;M
75808;1732,1298;35;F
75867;1178,972,1008,1173,1298,609,1061,1732,546,1059,439,551,1019,591,1062;39;F
76034;1061,1060,1059,1062;40;M
76125;1457,1169,1178,1399,1459;42;F
76311;1005,95,1009,1013,954,1007,1061,1059,1019,973,1062;38;F
76337;972,546,1060,439,1038,1298,1457,1459,1399,1059,551,1019,591,1062,954;37;F
76434;1007,1005,1169,609,1165,1009,972,1399,1059,1019,195,1013;40;M
76480;1007,1059;36;F
76525;1005,1007,1009,1013;34;M
76567;549,1743,195,1062,546,1169,1059,1008,1019,551,1178,1457,1399;45;F
76667;1457,1173,549,1459,1742,1399,954,1169,1743,1732,972,1061,1060,1059,1062;47;F
76707;195,1008,1399,972,1732,1165,549,1178,1457,1743,1459,904,1019,973,1742;33;M
77062;1061;67;F
77106;1732,904,1060,551,1062,1005,1007,1061,546,95,1009,1059,973,1013,954;14;M
77158;1298,195;21;F
77165;549,1005,1732,195,1173,1062,1742,1743,1459;20;M
77216;1298,1169,1165,1743,1173;39;F
77274;549,1459,1743,1742,1732,195;40;F
77429;1061,1160,591,1019,551,439,1060,904,95,1038,1173,1013,1062,1742,954;65;M
77490;1743,95,1059,1062,954;33;F
77569;904,95,1060,1009,1059,439,1019,1160,1038,1173,1013,591,1062,1742,954;64;F
77653;1169,1298,549,1743,1459,972,95,1399,1060,1059;38;F
77688;973,1178,1005,1165,1457,1743,1459,546,1399,904,1008,1059,551,954,1742;42;F
77937;1019,1165,1733,439,1062;16;F
78144;549,1743,1062,1742,1733,1457,1732,546,1059,439,551,1019;46;F
78211;1178,1732,546,1060,1008,1019,1038,1062;58;F
78245;609,1298,549,1178,1169,1733,1457,1732,972,95,1399,1060,1059,551,1160;35;F
78251;1742,954,1457,1743,1732,1459,546,904,1059,551,1019;79;M
78288;549,1298,1169,1457,1061,1743,1459,546,95,1060,1008,439,551,1038;46;F
78412;549,1733,1457,1743,1732,546,95,1059,439,551,1019,591,1062,1742;76;F
78445;1169;28;F
78461;1061,973;46;F
78555;1399,1732,1061,1165,1169,1173,1743,1178,1059,551;40;F
78558;1008,1060,546,1743,1733,1062,904,95,1061,1169,1007,1005,1009,1013,973;51;F
78562;972,1005,1733,1061,1060,904,1059,439,551,591,1062,954,1007,546,1019;45;M
78677;1005,1298,1007,1060,551,1019,1061,1457,609,1169,1732;59;F
78816;972,1062,1059,1743,1298;47;F
78872;1743,1732,1459,972,439,1019,1038,591,1062,1457,1169,546,551;36;F
78904;972,973,609,1733,1457,195,1742,1019,551,1059,1005,549,1743;40;F
78941;1743,439,1160,1005,1169,1007,1733,1061,95,904,1009,973,1013,1062,954;16;F
79004;549,1733,1061,1743,1732,972,904,1060,439,1019,1038,591,1062,954;28;F
79068;1005,1007,1061,972,1399,1009,1013,954;45;F
79184;1298,1061,1059,1062,1169;34;F
79232;1005,1007,1009,1013;15;M
79256;1005,1007,1009,1013;13;M
79280;1005,1009,1013,1062;8;M
79357;1008,904,972,549,1060,1038,1743,1457,609,1169,1732,1742,1062,591,1019;39;F
79460;904,1178,1459,1173,1742;29;M
79478;439,1732,1060,954;41;F
79516;1160,1743;50;M
79574;1060,1038,439,1005,549,1169,1733,1742,1732,1459,546,1059,551,1019,1173;25;M
79613;1742,1173,973,95,1178,1169,546,1060,551;28;F
79654;1743,546,195,1005,1399,1060,1059,1742,1062,1013,551,972,1733,549,1061;24;F
79662;1733,1743;27;M
79739;1178,1169,1459,546,904;45;F
79912;1007,1178,1169,1399,1019;52;F
79932;1732,1061,1733,609,549,1169,1743,1459,546,591,1019;37;F
79979;1178,549,1165,1169,609,1733,1743,972,546,1060,551,1019,1038,1173,591;13;F
80012;1178,549,1459,1743;53;M
80024;1178;54;M
80062;1005,1007,1009,1013;46;M
80066;1743,1459,973,195,1060,1298,1169,1165,546,1399,1062,1059,1173;59;F
80082;1169,609,1733,1743,1732,546,972,1060,551,1019,1038,1173,1062,591,954;6;M
80088;549,1178,1005,1169,609,1732,1743,1459,1060,1059,1019,1038,591,1062,1742;30;F
80099;1178,1457,1732,972,1059,439,551,1173,1062;38;M
80117;1169;20;F
80140;549,1169,1165,609,1743,546,972,904,1060,1019,1173,1038,591,1062,954;9;F
80144;1019;42;F
80177;1399,1062,954,1169,904;41;F
80192;1733,549,1169,1165,609,972,904,1060,1019,1038,1173,1062,591,1742,954;11;F
80204;609,1061,1062;20;F
80238;1169,904,954,1005,1007,1061,1732,95,1009,973,1013;48;F
80242;1007,1005,1009,1013;37;F
80276;1298,1743,1732,1060;37;F
80313;549,1298,1165,1743,551,1173;41;M
80367;1005,1007,904,1009,1013,954;12;F
80404;1062,973,1059,904,1743,1178,1733,1732,1459,972,551,1019,1160,1169,546;44;F
80441;1178,1399,904,1059,1160,1013,1742,954,1062,1173,1019,1008,1060,95,1007;44;F
80454;1062,1173,551,439,1399,95,546,1743,1061,609,1165,1298,549;13;M
80508;195,973,1742,1062,1173,439,551,609,1165,1298,549,1178;3;M
80556;1733,1743,1459,904,1060,1742;51;F
80560;549,1165,1733,1457,1743,1459,972,1399,1008,1059,551,1019,195;33;M
80576;1399,1459,1732,1457,609,549,1165,1743,904;22;M
80581;1059,972,1007,1178,549,1298,1005,1169,1165,1743,546,904,551,1019,1173;38;M
80613;1178,1298,1165,609,1399,1019,1062,972,546,1059,551;37;M
80692;1732,1061,1178,973,1173,591,549,1743,1169,1733,609,972,439,1019,1038;35;F
80710;551,1059,1008,1060,1457,904,95,546,972,1459,1732,1061,1733,1298,1169;25;F
80731;1060,972,1178,549,1298,1005,1169,1165,1743,546,904,1059,551,1019,1173;6;M
80787;1178,1165,1457,1459,1399,904,1060,1059,973,1160,1173,1062;24;M
80836;1178,549,1298,1005,1169,1165,1743,972,546,1060,1008,1059,551,1019,1173;4;M
80881;439,1733,609,1061,1457,972,546,1399,1060,1059,551,1019,1038,591,1062;41;F
80919;1062,546,549,1298,1007,1165,1733,1061,1459,972,1399,1060,551,1019,1160;46;M
80958;439,1019,1160,1038,591,1062,1742,954,1005,1007,1165,1061,1009,973,1013;72;M
81017;1743,1178,1008,1059,973,1062,954,1169;41;F
81041;1173,609;46;F
81096;1459,195,549,1169,1457,1743,1732,972,1399,904,1038,954,973,1062,1178;40;M
81110;1008;35;M
81156;95,1061,1298,954,1013;42;F
81186;1457,1459,1399;43;F
81324;546,1743,1169,1732,904,551,1173,1062;38;F
81327;1169,1743,1732,1008,1173,1062,1742,609,1059,551,1019;34;F
81421;195,904,546,1061,609,549,1298,1733,1457,1743,1732,1059,551,1742,1169;28;F
81642;1459,1457,1169,1298;25;M
81775;1008,551,1062,972,549,1169,1733,1743,1459,1732,546,1059,195,1173,1742;25;F
81823;549,609,1059,195,1038,1298,1061,1743,972,546,551,1019,591,1062,1742;2;M
81877;1178,1459,1399;44;M
81885;546,1399,195,1742,1178,1743,1173,1062;67;F
81908;1169,549,1005,1743,904,1742,954,1178,546,1399,1009,1059,551,973,1038;54;F
81918;549,1298,1457,1061,1743,1732,546,95,904,1009,551,1019,195,1742,954;52;F
81946;1160,591,1298,1060,439,1005,1007,1061,546,95,1009,551,1062,954,1013;36;M
82044;1062,591,1173,1038,1019,1009,1060,95,546,972,1743,609,1165,1169,1298;33;F
82046;1732,1173,1298,1457,1743,1459,972,1399,904,1009,1019,973,1062,954,1178;50;F
82100;1733,1457,1743,95,551,1059,1019,195,1013,1742,954;55;F
82222;1298,1005,1007,1061,546,95,1060,1009,439,551,1160,1013,591,1062,954;6;M
82293;1169,1298,1005,1007,1061,546,95,1060,1009,439,551,1160,1013,1062,954;5;M
82362;1178,973,1459;37;F
82404;1005,1007,609,972,973,1019;76;M
82503;1298,1062,1743,1165,549,1169,1733,1732,546,1173,1742;43;F
82606;1298,1061,546,95,1060,439,551,1160,591,1062,954,1005,1007,1009,1013;37;M
82710;1061,1298,1005,1007,546,95,1060,1009,439,551,1160,1013,591,1062,954;33;F
82730;1742,954,972,1298,549,904,95,1732,1743,1061,1733,1005,1007,1009,1013;56;F
82803;972,546;54;M
82845;591,1298,1005,1007,1061,95,546,1060,1009,439,551,1160,1013,1062,954;56;F
82883;1060,1008,954,1298,1743,972,546,439,1059,551,1019,1062;37;F
82924;1062,1743,1457,1459,972,1399,1059,551,195,1178;39;M
82946;546,1298,1005,1007,1061,95,1060,1009,439,551,1160,1013,591,1062,954;59;M
82962;1062,1457,1061,1060,973,1038,195,1019,546,1459,1732,1743,1733,549,1178;61;F
83053;195,549,546,1059,551;47;M
83072;195,954;64;F
83073;549,1743,1059,195;44;M
83085;1007,609,1733,954,1173,1038,1019,1743,1732,1169,1061,972,95,1013,1062;26;F
83146;1742,1457,1459,1399,95;29;F
83226;972,95,1060,1008,1059,439,551,195,973,1173,591,1062,1742,1178,1298;44;F
83314;549,195,1742,1743,1732,972,546;39;F
83316;1005,1007,1009,1013;65;F
83350;1733,1178,1165,972,546,1399,1059,1019,1013,549,1169,1743,1732,904,1038;53;F
83358;1732,1743,1457,1178,1165,609,1459,972,1399,904,1173,591,1742,954,195;48;F
83415;1038,1019,1009,609,1007,95,973,954;60;F
83425;1005,1007,1009,1013;84;F
83534;1160,1173,1007,549,1733,95,1060,1019,195,1038,1742;68;F
83536;1178,1733,904,1060,973,195,1743,549,1005,1061,1732,972,1038,1062,1742;43;F
83681;546,551,195,954,1742,1178,549,1743,1732,1459,972,904;16;F
83715;1062,1169,609,1733,1457,972,546,1060,1059,439,195;52;F
83731;1160,1173,1062,1742,954,1178,549,1169,1743,904,1009,1008,1059,439,551;48;M
83752;95;17;F
83767;1178,549,1733,1457,1743,1742;36;F
83787;1019,954,1007,1038,1173,591,1062,1061,1457,1178,1298,609,972,1399,1059;43;F
83791;549,1743,1732,95,1060,195,1742,1061;39;F
83846;972,1060,1008,1019,1160,1298,1005,1007,546,95,904,1009,1059,973,1062;39;F
83887;1062,1059,1399,546,1178;48;F
83970;1013,1062,904,1732,1733,1007,609,1457,1743,546,95,1060,439,1019,1742;57;F
84102;1061,546,1060,439,551,549,609,1743,972,1019,1038,1173,591,1062,1742;44;F
84174;95,1005,1007,1009,1013;72;F
84246;1005,1007,95,1009,1013;74;M
84291;549,1169,1399;25;F
84344;95,1178,549,1298,1005,1169,1165,1743,972,546,904,1008,551,1019,1173;66;M
84449;551,439,1060,546,1061,549,609,1743,972,1019,1038,1173,591,1062,1742;9;M
84454;549,1298,1005,1169,1007,1165,1743,972,546,95,904,551,1019,1173,1062;66;F
84670;1059,95,591,549,1743,1061,1732,1742;63;F
84796;609,954,1062,546,1007,1298,1165,1733,1732,972,1059,551,195,1173,591;42;M
84852;95;75;F
84919;195,1399,972,549,546,1165,1743;37;M
84956;95;72;F
85034;549,1169,1007,1743,1732,1459,1399,904,1059,195,1173,1742;70;M
85056;1019,1459,954,1061,1457,95,1399,904,1060,1059,439,551,1173,1013,1062;49;F
85070;551,1059,1009,904,1399,439,1060,1061;33;F
85090;439,973;45;M
85162;195;48;M
85172;609,1008,1733,1743,904,1059,1062,1742,954,549,972,1019,546,439,551;46;M
85198;549,1743,1732,195,1173,1742;69;F
85320;1178,1298,1459,1008,1173,1062;20;M
85389;95;41;F
85724;549,1732,1743,1459,1173,1742;38;F
85763;954,195,1732,1743;61;M
85972;95,1298,609,972,1013,973,1019,1059,1060,1178,1061,1399,551,1062,1457;38;F
86143;1457,1178,1059,546,551;42;F
86167;1743,1732,972,904,1060,1059,1019,973,1160,1173,1062,1178,1459,1169,954;56;M
86172;1173;56;M
86261;195,1038,1160,1013,1742,609,1007,1298,549,1459,1060,1059,1173,591,1062;49;M
86310;1019,1060,904,95,1733,1732,972,439,551,591,954,1298,1743,546;47;F
86331;954,1005,1007,1061,95,1009,973,1013;47;M
86417;1005,1007,1061,95,1009,1059,973,1013,954;47;F
86506;1005,1007,1061,95,1009,1059,973,1013,954;18;F
86564;1005,1007,1061,95,1009,1059,973,1013,954;14;M
86581;1062,546,1399,1059,551,1019,195,1732,972,904,1742,954,1457,1743,1459;36;F
86794;1733,1059,195;61;F
86846;1732,439,591,954,1160,1019,551,546,972,1165;44;F
86992;973,1062,1005,1061,546,1019,95;50;M
87024;1005,1007,1009,1013;54;M
87066;439,551,954,549,1298,1732,1060,1160,1059,546,1459,1169,1178,195,1173;47;F
87085;95,591;39;F
87103;1005,1169,609,1732,972,1060,1059,439,1019,591,1062;10;F
87105;1005,1007,1009,1013;13;M
87142;95;69;M
87148;1060,439,551,1298,1178,1169,1165,1457,1743,1459,1399,1008,1059,1160,1173;15;F
87162;1005,1007,1009,1013;52;F
87284;1169,1165;41;F
87320;95;68;F
87416;1173,1008,1038,546,1169,1733,972,1060,1059,439,551,1019,591,1062;32;F
87431;1160,551,1732,1165,972,546,439,1019,1038,591,954;11;F
87509;1733,609,1165,1298,549,1178,954,591,195,551,904,1459,1732,1743,1169;64;F
87534;95;44;F
87696;1178,549,1165,1457,1743,1732,1459,546,1008,551,195,973,1160,1173,1742;39;F
87713;1732,972,546,1060,1059,439,1038,1062;31;M
87844;195,1160,1742,549,1165,609,1733,1743,1732,972,546;15;F
88136;591,1742,549,1169,1165,1733,1743,1399,1008,1178,1298,1732,1062,972,954;33;F
88165;195,954,549,1165,609,1732,972,546,1399,439,551,1019,1160,1038,591;9;M
88220;1060,1743,1298,1733,1732,546,95,904,439,1019,1038,1062,954,1059,551;54;M
88381;1005,1007,1061,546,1009,551,973,1013;9;F
88570;1019,1060,95,1178,1059,1005,1007,1165,1733,1061,546,1009,973,1013,1062;48;M
88573;1165,1178,972,1059,591,546,1005,1007,1061,95,1060,1009,973,1013,1062;47;F
88661;549,1743,1732,1742,1169;34;F
88664;1007,1061,1732,95,973,1013;64;F
88669;1178,1298,1165,1743,1459,1019,973,1173,1062;21;M
88813;1742,1062,1160,973,1059,1060,1399,95,1459,1732,1743,1165,1178;29;M
88957;1005,1007,1009,1013;48;F
89005;439,1060,1298,1733,1743,1732,546,95,904,1059,551,1019,1038,1062,954;55;F
89010;1459,1399,1169,1007,1061,1732,95,904,1059,551,954,439,1019,546,1062;11;F
89021;1298;71;M
89033;1298;71;F
89118;1062,1173,1160,439,972,1733,1169,1178,1298,1165,1459,1399,904,591;35;M
89297;609,1733,1743,1732,972,546,1038,439,551,1019;62;F
89357;1459,1060,551,1019,1160,591,549,1457,95,439,1038,1062,1742,1743,546;38;F
89445;1178,1743,1459,195;43;M
89584;1019,549,1457,1743,1732,195,1742;39;M
89677;1742,1062,1160,551,439,1399,546,1459,1743,1169,549,1298,1165,1732,904;42;F
90216;1008,904,954,1005,1743,1062,1742;39;M
90315;549,954,1169;29;F
90357;1169,1165,1399,1062,195,1742;20;M
90517;1743,546,1060,195,1742,1061,1732,95,904,439,973,954;43;F
90580;1005,1007,1009,1013;68;M
90887;1399,904,1059,551,1019,1298,1165,609,1457,1459,972,1009,1160,591,954;66;F
91149;973;55;M
91213;1742,1019,195,549,1457,1732,1062,1733,1743,1459,546,95,551,1038,439;75;F
91259;1061,1059,973;40;F
91458;439,954,1742,1173,1459,1743,904,1062,1178;23;M
91473;1005,1007,1009,1013;82;F
91554;1173,1399,1459,1169,551;32;M
91558;1061,1160,1173,591,1169,609,1019,1062;37;F
91606;1178,1169,1733,439,1019,1173,1062;25;M
91617;1059,1019,1742,1733,1061,1743,1732,546,95,439,551,1038,591,1062;43;F
91627;1169,546,1060,1059,439,551,1019,1062;40;F
91647;1743,1062;27;F
91739;1169,1733,1459,904,439,1160,1062,549,1298,1165,1743,1732,1059,1173,1742;34;M
91744;549,1005,1061,1743,1009,195,973;29;F
91752;973,1038,954,1742,195,1059,904,95,972,1732,1733,549,1169,1459,1399;6;F
91756;1019,1160,1457,609,1005,1007,591,1178,1169,1165,972,1060,551,1062,954;27;F
91767;1165,609,972,439,1019,1160,1173,591,1062;38;M
91768;972,546,1019,1062,195,1732,1178,1298,1005,1459,1742,549,1743,973,1160;28;M
91772;1005,1457,1743,546,1059,439,551,1019,1062;7;M
91810;1038,1173,1013,439,1008,1743,1061,1165,1059,1062,546,1060,549,1298,551;44;F
91868;972;40;F
91900;1178,1459,1399,973;34;M
91933;1062,591,954,1173,1160,1059,904,1399,1459,1732,1743,1165,1169,1298,549;3;M
91988;1061,1732,95,1062,954;35;F
92053;1732,1743,1457,1733,1169,1008,1019,1038,1062,1060,609,1459,546,1059,551;46;F
92120;546,1061,1005,1007,1732,95,1009,1059,954,551,1019,973,1038,1013,591;32;F
92176;1060,439,1062,954,972,1059,551,1019,1038;43;F
92230;1019,1742,1160,609,1007,1005,549,1061,1732,972,591,1298,1169,1173,1062;29;F
92352;972,1743,549,1178,1742,195,1459,1061,1165,1298,1732,546,904,973,954;41;F
92382;1399,546,1743,1169,1298,549,904,195,1742,1178,1007,1457,1061,1732,95;38;F
92478;1013,1009,972,1007,1005,904,973;37;F
92496;1169,1060,1059,1013,1009,95,546,1005,1061,551,1062,973;33;M
92696;195;47;M
92698;609,1733,546,1060,1019,1173,591;37;F
92882;1178,549,609,1733,1743,1732,546,904,1060,439,1019,1062,1742;59;F
92891;1019;49;M
93066;973;37;F
93106;549,1169,1165,609,1743,972,1060,1019,195,973,1160,1038,1173,591,1062;46;M
93116;549,1169,609,1732,972,546,1060,1059,551,1019,973,1038,1173,591,1062;38;F
93119;1005,1169,1061,546,95,1060,1009,1059,551,973,1013,1062;27;F
93124;1743,546,1060,1059,551,1019,1038,591,1169,1733,1742,954,1459,972,904;41;F
93141;1457,1169,1165,904,195,1178,549,1298,1743,1732,1459,546,551,1173,1742;10;M
93165;1005,1169,1061,546,95,1060,1009,1059,551,973,1013,1062;6;F
93304;1743,1178,1298;30;M
93360;1005,1169,1061,546,95,1060,1009,1059,551,973,1013,1062;4;F
93434;1165,1732,1013,1169,609,1733,1059,1019,973,1173,1062,954;25;F
93579;1019,439,1743,1169,1298,549,1178,1732,546,95,904,1060,1059,551,1038;44;F
93693;1178,546,439,551,1733,1062,1019,95,1005,1007,1061,1009,1059,973,1013;58;F
93753;1169,1061,1173;36;F
93754;1457,609,1061,1743,439,1019,195,1038,1173,1062;28;F
93987;549,95,546,1008,439,1298,1743,1062,1742;34;F
94042;1743,972,546,439,1019,1038,1062;60;M
94077;1061,546,1060,1059,439,551,1019,195,1173,591,1062;40;F
94162;1459,1743,609,1733,551,1062,1005,1007,1061,546,95,1009,1059,973,1013;53;F
94340;1178,549,1169,1165,1743,1160,1173,1298,1062,973;26;M
94392;1061,1062,1457,1298,549,1733,1743,1732,1459,195,1742,1169,1060;25;F
94425;1007,1733,1459,954,195,1732,1457,1178,549,1743,546,904,973,1038,1742;36;M
94432;549;26;F
94447;549,1457,1743,546,439,551,1062;44;F
94467;1165,609,546,972,1008,551,1019,1160,1038,591,954;47;M
94637;1459,1732,1178,1457,1399;19;M
94642;1178,609,1061,1743,439,1019,1062,954,1169,1457,1399,904;29;F
94709;1061,1459,972,95,591,1019,195,973,1742,551,1178,549,1457,1743,1732;57;F
94711;1178,1298,1169,1165,1743,1459,546,1399,1059;35;M
94723;549,1169,1165;43;F
94773;1459,1732,439,546,1169,972,1298,549,1743,1742,1173,1062,954,1399,904;21;M
94860;609,1165,1732,546,972,551,1019,1160,1038,591,954;6;F
94865;1178,549,1298,1165,1743,1459,546,1399,904,551,1062,1742,1733,1059;41;F
94897;972,904;67;F
94913;546,195;33;M
95021;1178,1298,1459,1743;41;F
95182;439,546,551,1743,1178,1062,195,1019,1732,1298,549,1459,1399,904,1059;8;F
95277;95,1005,1007,1009,1013;39;F
95286;1007,1733,609,1743,439,1019,549,904,954,546,972,1298,1169,1173,1062;40;F
95349;1178,972,1019;36;F
95513;1059,904,1399,1459,549,1298,1732,1019,195,1062,1178,1743,551,546,439;6;M
95703;95,1005,1007,1009,1013;40;M
95846;1005,1007,95,1009,1013;9;F
95911;1178,439,1059,1743,609,904,1062,1060,1732,1298,546,551;49;M
95963;1009,1005,1007,1013;7;M
96149;1743,195,1733,1732,1298,1459,1008;47;M
96193;1732,546,95,904,591,1062,954,1178,1007,1399,1060,1008,1019,1160,1013;62;F
96224;549,1060,439,1178,1298,1743,551,1742,1062,1019,1169,1165,1732,546,1160;41;F
96578;972,904,439,551,1173,1742,1005,1743,1169,1019,591,1062;29;F
96609;551,1038,1178,549,1298,1169,1165,1743,1732,546,1060,439,1019,1160,1062;40;M
96654;1178,549,1169,1743,904,1008,195,973,1732;24;M
96829;439,1019,1173,591,551,1457,1165,1005,1007,1061,546,95,1059,973,1062;44;F
96884;1059,1038,1173,1013,1742,609,549,1007,1061,972,95,1060,1009,1062,439;47;F
96951;1459,973,1178,1298,546,1008,1059,954,904,1457,1743,1732,1005,551,1742;11;M
96964;1743,195;47;F
97076;439,546,551,1743,1178,1062,195,1019,1732,1298,549,1459,1399,904,1059;38;M
97153;954,1062,1038,1019,1061,1457,549,1169,1743,1732,1459,95,195,1742;31;F
97243;1178,549,1743;46;M
97396;1733,1743,1732,1459,1399,1742,1178;22;M
97546;609,1733,1061,1743,546,1059,551,439,1019,195,1038,1013,591,1062,1742;52;M
97611;549,1298,1169,1061,1743,1732,195;44;F
97898;1178,1743,1732,1399,551,1742;46;M
97964;549,1743,1732,1459,1742;49;M
98066;1062,1165;44;M
98073;1733,1743,1732,546;26;F
98091;1298,1732,1459,1178;50;F
98103;549,1732,1298,1173,1178,1459,1062;48;F
98168;1169,609,1457,1061,1743,1459,1399,1060,1059,439,1019,1038,1013,1742,1062;32;F
98179;1459,1061,1742,1160,1178,549,972,973,1169,1733,1732,546,904,551,954;33;F
98188;1005,1007,1009,1013;39;M
98197;973;14;F
98232;973;11;F
98296;972,1061,609,1062,1298;37;F
98537;551,1059,1743,609,1165,1005,1169,1007,1061,546,95,904,1009,973,954;70;F
98556;1038,1457,1732;56;F
98631;1178,1298,1008,954,1457,1733,549,1169,1743,1732,1459,1059,1173,1062,1742;31;F
98724;1008,1060,1399,549,1298,1169,1733,1457,1061,1743,1732,1459,904,1059,1019;43;F
98747;904,1178,549,1169,1165,1743,1732,1459,1399,195,1173,591,1062,1742,954;51;M
98749;1298,1743,609,1061,1059,1038,1742;46;M
98782;1399,1062,1178,1298,1169,1457,1743,1459,972,1059,1742,1732,551,1019,1038;41;F
98783;1008,1298,609,1457,972,546,1399,1060,1059,439,551,1019,1038,591,1062;10;M
98801;609,1062,439,1399,546,1732,549,1743,1742;47;M
98868;1742,551,1165;38;F
98871;1743,1457,1178,954,1160,1008,904,1732,1061,1733,549,1298,1169,1059,551;36;F
98926;973;60;F
99252;1173,1742,1062,1160,549,1061,1743,972,546,1060,1059,439,551,1019;39;F
99265;1160,1173,1062;46;M
99354;439,1059,1009,95,1732,609,1298,1169,1165,972,546,1399,904,551,1019;32;M
99397;1733,95,1059,551,1019,591,954,1298,1005,1007,1061,972,546,439,1062;48;F
99506;1059,439,973,1038,1178,549,1005,1732,1060,1008,551,1160,1062,1298,546;27;M
99515;549,1733,1743,1459,1059,1742;26;M
99794;551,1457,1061,1732,1178,549,1298,1743,1459,972,1019,195,973,1160,1742;43;F
100166;1169,1457,1732,1060,1008,1742,1733,1743,551;47;M
100171;549,1298,1733,1457,1743,1399,546,551,195,1062,1742;53;F
100322;904,591,1169,1732,1399,1160;22;M
100325;1059,954,1742,1038,904,1457,549,1178,1298,1061,1743,1732,1060,1062;27;F
100357;1178,549,1733,1743,1732,1459,95,1008,195,1742;45;M
100441;1743,1733,1178,549,1742,1019,1059,1169,1005,1007,1061,1009,973,1013,1062;38;M
100471;1038,1062,1459,1457,1743;49;F
100488;1298,954,1062,1059,904,1733;32;M
100938;549,1169,1743,1742;49;F
101005;1733,1732,1059,551,1019,954,1298,972,609,591,1062;41;F
101045;1743,551,549,1178,1005,1169,1007,1061,1060,1009,1059,973,1013,1062,1742;5;F
101404;1298,1743,1732,546,1059;22;F
101437;1178,1732,972,95,1059,973;40;F
101554;1008,1005,1169,1298,609,1733,1743,1732,972,546,551,1019,1038,591,1062;42;F
101742;1062,591,1038,1019,551,439,1060,904,546,1732,1743,1457,1733,609,1169;50;M
101743;1732,973,1061,1060,1059,1062;46;M
101804;1019,439,1059,1060,904,95,972,1061,1733,609,1005,1007,546,551;53;F
102007;549,1178,1005,1169,1007,609,1061,1009,973,1038,1013,1062,1742;10;F
102239;1178,609,1733,1743,1732,972,546,1060,439,1019,1038,591,1062,954;86;M
102327;1178,1459,904,1060,973,1742,954,1062;26;M
102412;973;54;M
102438;1169,546,1059;34;F
102513;954,1298;45;M
102639;1742,1062,1732,1743;31;F
102749;1019,1743,1298,549,1169,1165,1733,546,904,1059,439,551,973,1173,1062;34;F
102794;549,1742,904,439,1165,1743,1732,972,546,1062;32;M
103181;1743,1732,972,95,904,1060,551,1019,973,1160,1038,1013,591,1742,954;41;F
103251;609,1165,1732,972,546,1008,1019,1160,1038,591,954;4;F
103411;973;41;F
103727;95,1061,439,1742,1459,1743,1457,549,1298,1732,972,1019,195,591,1062;31;M
103742;1742,1169,1165,1459,972,1399,1008,1160,954,1298,1743,1732,95,1060,1038;37;M
103760;972,1743,904,1457,1061,1019,1038,1173,591,1742,549,1732,1459,1060,1062;31;F
104025;1169,1165,1457,1732,972,1399,195,954,1742,973,904,1459,1743,549,1178;24;M
104278;1742,1062,1013,1173,195,1019,1008,972,1732,1743,1061,1457,1007,1169,549;41;F
104334;549,1743,1742;52;F
104337;1060,439,1062,954,1298,609,972,546,551,1019,1038,591;42;F
104641;1399,1459,1743;36;M
104660;1173,1459,549,1732,195,1743,1742;37;F
104747;1009,1013,1005,1007;33;F
104788;1742,1062,591,1038,1173,1008,1399,546,1732,1743,1457,1007,1169,1298,549;16;M
104933;1061,1059,195,1013,1742,1060,551,591,1062;10;M
105103;904,1399,972,1743,1457,95,1008,1009,1013,551,549,1169,195,1173,1062;15;F
105202;1457,609,1178,1732,972,546,904,551,549,1298,1169,1059,1743,1733,954;24;F
105221;1459,549,972,546,1060,954,1742,1038,1298,1169,1732,1743,904,439;31;M
105244;904,1169,1165,1160,195,1019,439,1459,1732,1061,1733,549,1743,546,551;68;F
105416;1298,1062,591,1173,1038,1008,546,1169,954,609,972,904,1059,551,1019;33;F
105451;1019,1733,1298,549,1178,1165,1457,1743,1732,1459,95,1399,1059,551,1742;30;M
105487;1062,1008,904,1169,1732;34;F
105501;972,1732,195,1742,1062,1173,1008,1743,1061,1457,1733,1007,1169,1298,549;10;F
105700;1005,1743,1457,1061,95,1060,1059,439,551,1160,1178,1298,1169,1733,546;43;F
105784;1013,549,1007,1061,1399,1062,1059,546,1457,551,1459,1732,1743,1169,972;17;F
105826;1008,439,1173,591,1742,1160,195,972,549,1178,1165,1743,1732,1459,1399;32;F
105846;1019,549,1457,1743,1459,546,95,1060,439,551,1160,1038,591,1062,1742;14;M
105889;1732,546,904,551,954;52;F
106142;1019,591,195,1038,1013,1062,1169,1733,1459,1008,1742,1005,1298,1743,1399;41;F
106230;1178,1298;44;F
106577;1298,1743,1060,1008,1742;33;M
106612;1169,1005,549,1178,1007,1733,1457,1743,1732,1459,972,546,95,551,1019;40;F
106653;195,549,1743,1732,1742;38;F
106675;1008,1457,1169,549,609,1733,1732,972,1059,439,551,1019;61;F
106759;904;34;F
106888;95,1169,439,549,1298,1733,1743,1060,551,1038,1742,1457,1459,904,954;63;F
107045;1178,546;72;M
107051;972,439,1019,1062,1459,1732,1061,609,549,1743,546,1742,1733,904,954;52;F
107099;1019,904,972,546,95,1178,1457,1459,1399,1060,1059,439,551,1160,1062;13;M
107361;1178,1165,972,546,1019;71;F
107421;904,95,546,1178,1298,1457,1459,972,1399,1060,439,551,973,1160,1062;60;F
107612;551,1059,972,1178,1298,1457,1459,546,95,1399,1060,439,973,1160,1062;11;F
107857;1005,1007,1009,1013;54;F
107864;1732,1298,1019,1061,551,972,95,546,591;43;F
107868;1169,1007,1733,1457,1061,1743,95,1399,1060,1059,439,551,1160,1173,1062;34;F
107891;439,1038,1173,591,1062,1742,1178,549,1298,1061,972,546,1059,551,1019;39;M
108062;954,549,1298,1733,1743,1732,972,546,904,439,551,1019,1457,1459,1399;45;M
108081;1457,1743,1459,1399,551,195;47;M
108130;1005,546,1059,551,1459;45;F
108164;1061,1060,1059,1062;26;F
108168;95,1165,1169,973,1038,1178,1459,904,1060,439,954;47;F
108178;1160,1038,1062,549,1165,973,954,1178,1733,1743,1459,546,1060,1019,1742;47;F
108365;1733,1059,1062,549,1298,1743,1732,972,551,1038,1742;30;F
108377;1061,1059,591;35;F
108600;1169,1743,1732,1060,1038;34;F
108810;609,954,551,1298,1005,1007,1061,546,95,1009,1059,439,973,1013,1062;46;F
108817;1733,1743,546,1008,1059,954,1169,972,904,551,1019,1160,1173,591,1062;36;F
108821;549,1298,1733,1457,1743,1732,1459,972,546,1399,904,439,551,1019,954;11;M
108842;609,972,1019,1038,591;61;F
108911;1459,95,551,1019,1160,954,1732,1061,1733,609,549,1178;20;F
108913;609,972,1019,1038,591;61;M
108921;591,549,1457,1743,1459,546,95,1060,439,551,1019,1160,1038,1062,1742;6;F
108942;1298,1732,1060,972,546,95,551;12;F
108970;609,972,1019,1038,591;81;F
108987;1298,1005,1169,546,439,551,1019,1013,591,1062;47;M
109077;609,972,1019,1038,591;32;M
109086;1038,973,1459,1732,1743,549,1178,1005,1457,1399,546,904,1059,551,1742;7;M
109115;1061,1732,972,1399,1059,439,1019,1013,1062,954,1298,1459,904,551,1173;34;F
109161;609,972,1019,1038,591;90;M
109284;95;52;F
109543;1005,954,1008,1399,546,1459,1178,1457,1743,1732,904,1059,551,973,1742;5;F
109635;549,1743,1742;53;M
109743;1013,1733,1173,195,549,1742,1005,95,1732,1298,1743,546,551,1019,1038;48;F
109771;1005,1059;44;F
109838;1457,1459,546,95,904,1060,1178,549,1298,1743,1732,439,195,1062,1742;63;M
109862;1178,1298,1005,1169,1457,1733,1061,1743,546,95,1060,1059,439,551,1160;42;M
109874;1173,1399,1459,1743,1165;75;M
109904;1733,95,904,972,1459,1061,549,1298,1457,1743,1732,1060,195,1742;51;F
109992;549,1743,1732,546,1059,551,1173,1062;38;F
109993;1459,95,1399,1178,972,904,1059,551,973,954;69;F
110024;973,1005,1061,546,95,1009,1059;38;F
110051;549,1733,1165,1459,1732,546,1060,195,1399,1298,1169,904,1743,972,1742;14;F
110106;439,1062,1178,1459,904,1059,954;49;M
110206;549,1457,1743,1732,1459,195,1742;24;F
110403;1298,1005,1007,609,1061,546,95,1009,1059,439,551,973,1013,1062,954;49;M
110438;1733,972,546,904,439,551,1038,1062;41;M
110834;972,546,439,551,1019,1062;14;M
110835;954,1007,95,1059,973,1013,1062;44;F
111006;1298,1005,1007,609,1061,546,95,1009,1059,439,551,973,1013,1062,954;9;M
111156;546,439,1160,591,1733,1459,1059,1019,195,1742,549,1743,1732,1060,1062;31;M
111259;546,1399,1060,195,1459,1732,1165,549,1005,1743,972,1059,551,1173,1742;38;M
111286;1008,1178,1743,1732,549,1059,551,1173,1062,1165,1005,195,972,546,1298;15;M
111483;1298,1005,1007,1733,1061,546,1008,1059,439,551,1160,1173;30;F
111663;1173,904,1298,1038,609,1061,1019,973,954,591;61;F
111698;1298,1005,1007,609,1061,546,95,1009,1059,439,551,973,1013,1062,954;6;M
111783;1008,1178,1169,1165,1733,1743,1732,1459,972,546,1399,1173,954,973,1160;47;M
111855;904,1013,954,1732,195,1742,549,1743;38;F
111935;1008;6;F
111941;1005,1007,1009,1013;42;F
111988;1008;41;F
112001;1298,1061,1732,972,546,95,551,1019,591;13;F
112061;1008;68;F
112121;1008;69;M
112183;1008;53;M
112217;1062,1019,551,1059,1743,1457,1178,1298,1005,1169,1459,972,1399,1060,195;37;F
112296;1298,1061,1732,972,95,546,551,1019,591;72;F
112317;195,546;40;M
112339;439,1742,1173,549,1743,1059,551,195,1062,1298,546;36;M
112414;439,1742,1165,1169,1005,1178,1743,1732,904,1008,973,1160,1173,1062,954;24;M
112446;439,1062,1298;22;M
112576;1298,1005,609,1007,1061,546,95,1009,1059,439,551,973,1013,1062,954;72;F
112659;1743,195,1742,1732,546,1733,1298,954,1019,551,1059,904,972,1169,609;38;F
112667;1061,1169,1732,1060;22;M
112731;549,1732,1459,904,439,1742,954,1733,1743,972,546,1059,551,1019;39;M
112878;591,954,1061,1733,609,549,1298,1743,1732,1059,1019,1742;51;M
112887;546,195;14;M
112960;1005,1007,1009,1013;46;F
113020;1732,1059,551,195,1173,1742,549,1743;43;F
113099;1005,1007,1009,1013;20;M
113170;1005,1007,1009,1013;16;M
113171;546,195;10;M
113238;1005,1007,1009,1013;51;F
113322;972,551,1742,1178,549,1169,1743,1732,546,904,1019,1038,591,1062,954;48;F
113339;546,195;67;F
113343;1005,1007,1009,1013;13;M
113479;1059,551,1005,1743,1457,549,1169,1013,1062,439,1008,546,1732,1298,1742;63;M
113484;439,1019,1009,95,1733,549,1298,1061,1743,1459,1732,1060,1059,1742;49;F
113486;1005,1007,1009,1013;8;F
113568;1007,1062,1013,551,904,1732,1733,954,549,1743,546,1059,1019,1173,1742;34;M
113617;546,195;43;F
113797;549,1743,1459;29;F
113799;95,1008,973,1733,1457,546,551,1019,1013,954,1061,1007,1169,1059,1062;40;F
113932;1013,591,1019,439,1008,1399,1178,549,1298,1165,1743,1732,546,195,1742;14;M
114047;1007,549,1733,1743,546,95,904,1059,551,1019,195,1173,1062,1742,954;59;F
114083;972,1007,1732,1178,1169,1457,1743,1459,1399,904,1060,1059,551,1019,195;10;M
114212;609,1733,1457,1061,1743,546,95,904,1060,439,551,1038,1013,591,954;51;M
114447;1178,1005,1169,1007,609,1733,1457,1743,1732,1459,972,546,95,551,1019;65;F
114521;591,1062,1298,1005,1165,1732,1007,1061,95,1060,1059,551,1019,973,1013;6;F
114529;1013,954,549,1062,95,546,972,1743,1060,1061,1059,439,551,1019,1173;39;F
114672;609,1732,1178,1169,1457,1743,1459,972,1399,904,1060,1059,551,1019,195;4;F
114796;1007,1178,1165,1733,1457,1459,973,1298,1169,1061,972,546,95,439,1062;19;F
114868;549,1298,1733,1743,1732,972,195,904,546,439,1059,1169,551,1019,1062;37;F
114900;1062,1005,609,1061,95,973;40;F
115022;1062,973,1019,904,1061,1457,1007,549,1298,1743,1732,1060,1008,1059,1013;40;M
115071;1062,1178,1169,1457,1743,1732,1459,972,1399,904,1060,1059,551,1019,195;1;F
115132;1165,1178,549,1457,1743,1459,972,546,1399,1059,439,551,1019,1173,1062;38;F
115165;1742,551,1743,1457,549,1178,1298,1732,546;45;M
115569;1059,1732,1061,1733,546,1019,195,1160,1173,1742,1062,972,1743,549,954;30;M
115634;1457,1459,1399;19;M
115639;1173,1062,546,1165,1457,1459,1399;17;F
115687;609,972,546,1060,1059,439,551,1019,1038,591,1062;13;F
115696;1169,1733,904,1060,439,551,1062,954;48;M
115863;973,1173,1062,1742,1399,546,1732,1165,1178,1459,972,904,1060,1059,551;39;M
115875;1298,609,1457,1061,972,546,1060,1009,1059,439,551,1019,1038,591,1062;16;M
115981;1013,954;29;M
115984;1743,1732,1459;25;F
115990;1298,1061,972,546,1060,1059,439,551,1019,1038,591,1062;46;M
99999922524;1298;36;F